<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Sitemap
 */

// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('quick_sitemap_options');
delete_option('quick_sitemap_last_generated');

// Clear any scheduled events
$timestamp = wp_next_scheduled('quick_sitemap_cron_generate');
if ($timestamp) {
    wp_unschedule_event($timestamp, 'quick_sitemap_cron_generate');
}

// Flush rewrite rules
flush_rewrite_rules();
