<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://plugins.quickpr.co/
 * @since             1.0.0
 * @package           Quick_Sitemap
 *
 * @wordpress-plugin
 * Plugin Name:       Quick Sitemap
 * Plugin URI:        https://plugins.quickpr.co/quick-sitemap
 * Description:       A powerful XML sitemap generator with support for Google News, images, videos, and multilingual sites (WPML & Polylang).
 * Version:           1.0.0
 * Author:            Quick LLC
 * Author URI:        https://plugins.quickpr.co/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       quick-sitemap
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('QUICK_SITEMAP_VERSION', '1.0.0');
define('QUICK_SITEMAP_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('QUICK_SITEMAP_PLUGIN_URL', plugin_dir_url(__FILE__));

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-quick-sitemap-activator.php
 */
function activate_quick_sitemap() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-quick-sitemap-activator.php';
    Quick_Sitemap_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-quick-sitemap-deactivator.php
 */
function deactivate_quick_sitemap() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-quick-sitemap-deactivator.php';
    Quick_Sitemap_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_quick_sitemap');
register_deactivation_hook(__FILE__, 'deactivate_quick_sitemap');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-quick-sitemap.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_quick_sitemap() {
    $plugin = new Quick_Sitemap();
    $plugin->run();
}
run_quick_sitemap();
