<?php
/**
 * XSL stylesheet for sitemap
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Sitemap
 * @subpackage Quick_Sitemap/public/partials
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Get plugin options
$options = get_option('quick_sitemap_options', array());

// Output the XML declaration and stylesheet
header('Content-Type: text/xsl; charset=UTF-8');

// Output the XML declaration
echo '<?xml version="1.0" encoding="UTF-8"?>';

// Output the stylesheet content
$stylesheet = <<<EOT
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
                xmlns:video="http://www.google.com/schemas/sitemap-video/1.1"
                xmlns:news="http://www.google.com/schemas/sitemap-news/0.9">

    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <xsl:template match="/">
        <html>
            <head>
                <title>XML Sitemap - Quick Sitemap</title>
                <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
                <style type="text/css">
                    body {
                        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
                        color: #333;
                        font-size: 14px;
                        line-height: 1.5;
                        margin: 0;
                        padding: 0;
                        background-color: #f5f5f5;
                    }
                    .container {
                        max-width: 1200px;
                        margin: 0 auto;
                        padding: 20px;
                    }
                    .header {
                        background-color: #fff;
                        padding: 20px;
                        border-radius: 5px;
                        margin-bottom: 20px;
                        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
                    }
                    .header h1 {
                        margin: 0;
                        font-size: 24px;
                        color: #23282d;
                    }
                    .header p {
                        margin: 10px 0 0;
                        color: #666;
                    }
                    .content {
                        background-color: #fff;
                        padding: 20px;
                        border-radius: 5px;
                        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
                    }
                    table {
                        width: 100%;
                        border-collapse: collapse;
                    }
                    th {
                        text-align: left;
                        padding: 10px;
                        background-color: #f8f8f8;
                        border-bottom: 1px solid #ddd;
                        font-weight: 600;
                    }
                    td {
                        padding: 10px;
                        border-bottom: 1px solid #eee;
                    }
                    tr:hover td {
                        background-color: #f9f9f9;
                    }
                    a {
                        color: #0073aa;
                        text-decoration: none;
                    }
                    a:hover {
                        color: #00a0d2;
                        text-decoration: underline;
                    }
                    .footer {
                        margin-top: 20px;
                        text-align: center;
                        color: #666;
                        font-size: 12px;
                    }
                    .count {
                        background-color: #f8f8f8;
                        border-radius: 3px;
                        padding: 5px 10px;
                        margin-top: 10px;
                        display: inline-block;
                        font-size: 12px;
                        color: #666;
                    }
                    .image-info, .video-info, .news-info {
                        margin-left: 20px;
                        padding: 5px 10px;
                        border-left: 3px solid #eee;
                        font-size: 12px;
                        margin-top: 5px;
                    }
                    .image-info {
                        border-left-color: #4CAF50;
                    }
                    .video-info {
                        border-left-color: #2196F3;
                    }
                    .news-info {
                        border-left-color: #FF9800;
                    }
                    @media (max-width: 768px) {
                        .container {
                            padding: 10px;
                        }
                        .header, .content {
                            padding: 15px;
                        }
                        table {
                            font-size: 12px;
                        }
                        th, td {
                            padding: 8px;
                        }
                        .header h1 {
                            font-size: 20px;
                        }
                    }
                </style>
            </head>
            <body>
                <div class="container">
                    <div class="header">
                        <h1>XML Sitemap</h1>
                        <p>Generated by Quick Sitemap - A WordPress plugin for better SEO</p>
                    </div>
                    
                    <div class="content">
                        <xsl:choose>
                            <xsl:when test="count(sitemap:sitemapindex/sitemap:sitemap) &gt; 0">
                                <h2>Sitemap Index</h2>
                                <p>This sitemap index contains <xsl:value-of select="count(sitemap:sitemapindex/sitemap:sitemap)"/> sitemaps.</p>
                                <div class="count">Total Sitemaps: <xsl:value-of select="count(sitemap:sitemapindex/sitemap:sitemap)"/></div>
                                
                                <table>
                                    <tr>
                                        <th>URL</th>
                                        <th>Last Modified</th>
                                    </tr>
                                    <xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
                                        <tr>
                                            <td>
                                                <a href="{sitemap:loc}">
                                                    <xsl:value-of select="sitemap:loc"/>
                                                </a>
                                            </td>
                                            <td>
                                                <xsl:if test="sitemap:lastmod">
                                                    <xsl:value-of select="sitemap:lastmod"/>
                                                </xsl:if>
                                                <xsl:if test="not(sitemap:lastmod)">
                                                    -
                                                </xsl:if>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </xsl:when>
                            
                            <xsl:when test="count(sitemap:urlset/sitemap:url) &gt; 0">
                                <h2>URL List</h2>
                                <p>This sitemap contains <xsl:value-of select="count(sitemap:urlset/sitemap:url)"/> URLs.</p>
                                <div class="count">Total URLs: <xsl:value-of select="count(sitemap:urlset/sitemap:url)"/></div>
                                
                                <table>
                                    <tr>
                                        <th>URL</th>
                                        <th>Priority</th>
                                        <th>Change Frequency</th>
                                        <th>Last Modified</th>
                                    </tr>
                                    <xsl:for-each select="sitemap:urlset/sitemap:url">
                                        <tr>
                                            <td>
                                                <a href="{sitemap:loc}">
                                                    <xsl:value-of select="sitemap:loc"/>
                                                </a>
                                                
                                                <xsl:if test="image:image">
                                                    <div class="image-info">
                                                        Contains <xsl:value-of select="count(image:image)"/> images
                                                    </div>
                                                </xsl:if>
                                                
                                                <xsl:if test="video:video">
                                                    <div class="video-info">
                                                        Contains <xsl:value-of select="count(video:video)"/> videos
                                                    </div>
                                                </xsl:if>
                                                
                                                <xsl:if test="news:news">
                                                    <div class="news-info">
                                                        Google News
                                                    </div>
                                                </xsl:if>
                                            </td>
                                            <td>
                                                <xsl:if test="sitemap:priority">
                                                    <xsl:value-of select="sitemap:priority"/>
                                                </xsl:if>
                                                <xsl:if test="not(sitemap:priority)">
                                                    0.5
                                                </xsl:if>
                                            </td>
                                            <td>
                                                <xsl:if test="sitemap:changefreq">
                                                    <xsl:value-of select="sitemap:changefreq"/>
                                                </xsl:if>
                                                <xsl:if test="not(sitemap:changefreq)">
                                                    -
                                                </xsl:if>
                                            </td>
                                            <td>
                                                <xsl:if test="sitemap:lastmod">
                                                    <xsl:value-of select="sitemap:lastmod"/>
                                                </xsl:if>
                                                <xsl:if test="not(sitemap:lastmod)">
                                                    -
                                                </xsl:if>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </xsl:when>
                            
                            <xsl:otherwise>
                                <p>This sitemap contains no URLs.</p>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                    
                    <div class="footer">
                        <p>Generated by <a href="https://wordpress.org/plugins/quick-sitemap/" target="_blank">Quick Sitemap</a> for WordPress</p>
                    </div>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
EOT;

// Output the stylesheet
echo $stylesheet;