<?php
/**
 * Fired during plugin deactivation
 *
 * @link       https://plugins.quickpr.co/
 * @since      1.0.0
 *
 * @package    Quick_Sitemap
 * @subpackage Quick_Sitemap/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Quick_Sitemap
 * @subpackage Quick_Sitemap/includes
 * @author     Quick LLC <info@quickpr.co>
 */
class Quick_Sitemap_Deactivator {

    /**
     * Deactivate the plugin.
     *
     * Flush rewrite rules to remove sitemap URLs.
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        // Flush rewrite rules to remove sitemap URLs
        flush_rewrite_rules();
    }
}
