<?php
/**
 * Provide a admin area view for viewing the sitemap
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Sitemap
 * @subpackage Quick_Sitemap/admin/partials
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Get plugin options
$options = get_option('quick_sitemap_options', array());

// Get sitemap URL
$sitemap_url = home_url('/sitemap.xml');

// Get post types
$post_types = get_post_types(array('public' => true), 'objects');
$enabled_post_types = array();
foreach ($post_types as $post_type) {
    if (isset($options['sitemap_items'][$post_type->name]) && $options['sitemap_items'][$post_type->name]) {
        $enabled_post_types[$post_type->name] = $post_type;
    }
}

// Get taxonomies
$taxonomies = get_taxonomies(array('public' => true), 'objects');
$enabled_taxonomies = array();
foreach ($taxonomies as $taxonomy) {
    if (isset($options['sitemap_taxonomies'][$taxonomy->name]) && $options['sitemap_taxonomies'][$taxonomy->name]) {
        $enabled_taxonomies[$taxonomy->name] = $taxonomy;
    }
}
?>

<div class="wrap quick-sitemap-wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="quick-sitemap-header">
        <div class="quick-sitemap-actions">
            <a href="<?php echo esc_url($sitemap_url); ?>" target="_blank" class="button button-primary">
                <span class="dashicons dashicons-external"></span> <?php esc_html_e('Open Sitemap in New Tab', 'quick-sitemap'); ?>
            </a>
            <button id="quick-sitemap-regenerate" class="button button-secondary">
                <span class="dashicons dashicons-update"></span> <?php esc_html_e('Regenerate Sitemap', 'quick-sitemap'); ?>
            </button>
            <button id="quick-sitemap-ping" class="button button-secondary">
                <span class="dashicons dashicons-share"></span> <?php esc_html_e('Ping Search Engines', 'quick-sitemap'); ?>
            </button>
        </div>
        
        <div id="quick-sitemap-notice" class="notice" style="display: none;"></div>
    </div>
    
    <div class="quick-sitemap-view-container">
        <h2><?php esc_html_e('Sitemap Structure', 'quick-sitemap'); ?></h2>
        
        <div class="quick-sitemap-structure">
            <ul class="quick-sitemap-tree">
                <li class="quick-sitemap-tree-item">
                    <a href="<?php echo esc_url($sitemap_url); ?>" target="_blank">
                        <span class="dashicons dashicons-networking"></span> <?php esc_html_e('Sitemap Index', 'quick-sitemap'); ?>
                    </a>
                    <ul>
                        <?php foreach ($enabled_post_types as $post_type) : ?>
                            <li class="quick-sitemap-tree-item">
                                <a href="<?php echo esc_url(home_url('/sitemap-' . $post_type->name . '.xml')); ?>" target="_blank">
                                    <span class="dashicons dashicons-admin-page"></span> <?php echo esc_html($post_type->labels->name); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                        
                        <?php foreach ($enabled_taxonomies as $taxonomy) : ?>
                            <li class="quick-sitemap-tree-item">
                                <a href="<?php echo esc_url(home_url('/sitemap-tax-' . $taxonomy->name . '.xml')); ?>" target="_blank">
                                    <span class="dashicons dashicons-category"></span> <?php echo esc_html($taxonomy->labels->name); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                        
                        <?php if (isset($options['sitemap_include_images']) && $options['sitemap_include_images']) : ?>
                            <li class="quick-sitemap-tree-item">
                                <a href="<?php echo esc_url(home_url('/sitemap-images.xml')); ?>" target="_blank">
                                    <span class="dashicons dashicons-format-image"></span> <?php esc_html_e('Images', 'quick-sitemap'); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php if (isset($options['sitemap_include_videos']) && $options['sitemap_include_videos']) : ?>
                            <li class="quick-sitemap-tree-item">
                                <a href="<?php echo esc_url(home_url('/sitemap-videos.xml')); ?>" target="_blank">
                                    <span class="dashicons dashicons-format-video"></span> <?php esc_html_e('Videos', 'quick-sitemap'); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php if (isset($options['sitemap_google_news']) && $options['sitemap_google_news']) : ?>
                            <li class="quick-sitemap-tree-item">
                                <a href="<?php echo esc_url(home_url('/sitemap-news.xml')); ?>" target="_blank">
                                    <span class="dashicons dashicons-media-text"></span> <?php esc_html_e('Google News', 'quick-sitemap'); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            </ul>
        </div>
        
        <h2><?php esc_html_e('Sitemap Preview', 'quick-sitemap'); ?></h2>
        
        <div class="quick-sitemap-preview">
            <iframe src="<?php echo esc_url($sitemap_url); ?>" width="100%" height="500" frameborder="0"></iframe>
        </div>
        
        <h2><?php esc_html_e('Submit Your Sitemap', 'quick-sitemap'); ?></h2>
        
        <div class="quick-sitemap-submit-info">
            <p><?php esc_html_e('To ensure search engines can find your sitemap, you can submit it directly to search engines using the following links:', 'quick-sitemap'); ?></p>
            
            <ul>
                <li>
                    <strong><?php esc_html_e('Google Search Console:', 'quick-sitemap'); ?></strong>
                    <a href="<?php echo esc_url('https://search.google.com/search-console/sitemaps?resource_id=' . urlencode(home_url())); ?>" target="_blank">
                        <?php esc_html_e('Submit to Google', 'quick-sitemap'); ?>
                    </a>
                </li>
                <li>
                    <strong><?php esc_html_e('Bing Webmaster Tools:', 'quick-sitemap'); ?></strong>
                    <a href="<?php echo esc_url('https://www.bing.com/webmasters/sitemaps'); ?>" target="_blank">
                        <?php esc_html_e('Submit to Bing', 'quick-sitemap'); ?>
                    </a>
                </li>
            </ul>
            
            <p><?php esc_html_e('You can also add the following line to your robots.txt file to help search engines discover your sitemap:', 'quick-sitemap'); ?></p>
            
            <pre>Sitemap: <?php echo esc_url($sitemap_url); ?></pre>
        </div>
    </div>
</div>
