<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Sitemap
 * @subpackage Quick_Sitemap/admin/partials
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Get plugin options
$options = get_option('quick_sitemap_options', array());

// Get post types
$post_types = get_post_types(array('public' => true), 'objects');

// Get taxonomies
$taxonomies = get_taxonomies(array('public' => true), 'objects');

// Get last generated time
$last_generated = get_option('quick_sitemap_last_generated', 0);
?>

<div class="wrap quick-sitemap-wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="quick-sitemap-header">
        <div class="quick-sitemap-actions">
            <a href="<?php echo esc_url(home_url('/sitemap.xml')); ?>" target="_blank" class="button button-secondary">
                <span class="dashicons dashicons-visibility"></span> <?php esc_html_e('View Sitemap', 'quick-sitemap'); ?>
            </a>
            <button id="quick-sitemap-regenerate" class="button button-secondary">
                <span class="dashicons dashicons-update"></span> <?php esc_html_e('Regenerate Sitemap', 'quick-sitemap'); ?>
            </button>
            <button id="quick-sitemap-ping" class="button button-secondary">
                <span class="dashicons dashicons-share"></span> <?php esc_html_e('Ping Search Engines', 'quick-sitemap'); ?>
            </button>
        </div>
        
        <?php if ($last_generated > 0) : ?>
            <div class="quick-sitemap-last-generated">
                <p><?php printf(esc_html__('Last generated: %s', 'quick-sitemap'), date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $last_generated)); ?></p>
            </div>
        <?php endif; ?>
        
        <div id="quick-sitemap-notice" class="notice" style="display: none;"></div>
    </div>
    
    <div class="quick-sitemap-tabs">
        <ul class="quick-sitemap-tab-nav">
            <li class="active"><a href="#general-settings"><?php esc_html_e('General Settings', 'quick-sitemap'); ?></a></li>
            <li><a href="#content-settings"><?php esc_html_e('Content Settings', 'quick-sitemap'); ?></a></li>
            <li><a href="#advanced-settings"><?php esc_html_e('Advanced Settings', 'quick-sitemap'); ?></a></li>
            <?php if (isset($options['sitemap_google_news']) && $options['sitemap_google_news']) : ?>
                <li><a href="#news-settings"><?php esc_html_e('Google News', 'quick-sitemap'); ?></a></li>
            <?php endif; ?>
        </ul>
        
        <div class="quick-sitemap-tab-content">
            <form method="post" action="options.php">
                <?php settings_fields('quick_sitemap_options'); ?>
                
                <div id="general-settings" class="quick-sitemap-tab-pane active">
                    <h2><?php esc_html_e('General Settings', 'quick-sitemap'); ?></h2>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row">
                                <label for="quick-sitemap-enabled"><?php esc_html_e('Enable Sitemap', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="checkbox" id="quick-sitemap-enabled" name="quick_sitemap_options[sitemap_enabled]" value="1" <?php checked(isset($options['sitemap_enabled']) ? $options['sitemap_enabled'] : true); ?>>
                                    <?php esc_html_e('Enable XML sitemap generation', 'quick-sitemap'); ?>
                                </label>
                                <p class="description"><?php esc_html_e('When enabled, the sitemap will be available at', 'quick-sitemap'); ?> <a href="<?php echo esc_url(home_url('/sitemap.xml')); ?>" target="_blank"><?php echo esc_html(home_url('/sitemap.xml')); ?></a></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e('Include Images', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="checkbox" name="quick_sitemap_options[sitemap_include_images]" value="1" <?php checked(isset($options['sitemap_include_images']) ? $options['sitemap_include_images'] : true); ?>>
                                    <?php esc_html_e('Include images in sitemap', 'quick-sitemap'); ?>
                                </label>
                                <p class="description"><?php esc_html_e('Add image information to the sitemap to help search engines index your images.', 'quick-sitemap'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e('Include Videos', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="checkbox" name="quick_sitemap_options[sitemap_include_videos]" value="1" <?php checked(isset($options['sitemap_include_videos']) ? $options['sitemap_include_videos'] : true); ?>>
                                    <?php esc_html_e('Include videos in sitemap', 'quick-sitemap'); ?>
                                </label>
                                <p class="description"><?php esc_html_e('Add video information to the sitemap to help search engines index your videos.', 'quick-sitemap'); ?></p>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e('Google News Sitemap', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="checkbox" name="quick_sitemap_options[sitemap_google_news]" value="1" <?php checked(isset($options['sitemap_google_news']) ? $options['sitemap_google_news'] : false); ?>>
                                    <?php esc_html_e('Enable Google News sitemap', 'quick-sitemap'); ?>
                                </label>
                                <p class="description"><?php esc_html_e('Create a separate sitemap for Google News. Only enable this if your site is approved for Google News.', 'quick-sitemap'); ?></p>
                                
                                <?php if (isset($options['sitemap_google_news']) && $options['sitemap_google_news']) : ?>
                                <div class="quick-sitemap-news-links" style="margin-top: 10px;">
                                    <p>
                                        <strong><?php esc_html_e('Google News Sitemap URLs:', 'quick-sitemap'); ?></strong>
                                    </p>
                                    <ul style="margin-left: 20px; list-style-type: disc;">
                                        <li>
                                            <a href="<?php echo esc_url(home_url('/sitemap-news.xml')); ?>" target="_blank">
                                                <?php echo esc_html(home_url('/sitemap-news.xml')); ?>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo esc_url(home_url('/news-sitemap.xml')); ?>" target="_blank">
                                                <?php echo esc_html(home_url('/news-sitemap.xml')); ?>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e('Ping Search Engines', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="checkbox" name="quick_sitemap_options[sitemap_ping_search_engines]" value="1" <?php checked(isset($options['sitemap_ping_search_engines']) ? $options['sitemap_ping_search_engines'] : true); ?>>
                                    <?php esc_html_e('Automatically ping search engines when content is updated', 'quick-sitemap'); ?>
                                </label>
                                <p class="description"><?php esc_html_e('Notify search engines when you publish or update content.', 'quick-sitemap'); ?></p>
                                
                                <div class="quick-sitemap-ping-services" style="margin-top: 10px;">
                                    <label>
                                        <input type="checkbox" name="quick_sitemap_options[sitemap_ping_services][google]" value="1" <?php checked(isset($options['sitemap_ping_services']['google']) ? $options['sitemap_ping_services']['google'] : true); ?>>
                                        <?php esc_html_e('Google', 'quick-sitemap'); ?>
                                    </label>
                                    <br>
                                    <label>
                                        <input type="checkbox" name="quick_sitemap_options[sitemap_ping_services][bing]" value="1" <?php checked(isset($options['sitemap_ping_services']['bing']) ? $options['sitemap_ping_services']['bing'] : true); ?>>
                                        <?php esc_html_e('Bing', 'quick-sitemap'); ?>
                                    </label>
                                </div>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row">
                                <label><?php esc_html_e('Stylesheet', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <label>
                                    <input type="checkbox" name="quick_sitemap_options[sitemap_stylesheet]" value="1" <?php checked(isset($options['sitemap_stylesheet']) ? $options['sitemap_stylesheet'] : true); ?>>
                                    <?php esc_html_e('Add stylesheet to sitemap', 'quick-sitemap'); ?>
                                </label>
                                <p class="description"><?php esc_html_e('Makes the sitemap human-readable when viewed in a browser.', 'quick-sitemap'); ?></p>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <div id="content-settings" class="quick-sitemap-tab-pane">
                    <h2><?php esc_html_e('Content Settings', 'quick-sitemap'); ?></h2>
                    
                    <h3><?php esc_html_e('Post Types', 'quick-sitemap'); ?></h3>
                    <p><?php esc_html_e('Select which post types to include in the sitemap:', 'quick-sitemap'); ?></p>
                    
                    <table class="form-table">
                        <?php foreach ($post_types as $post_type) : ?>
                            <tr>
                                <th scope="row">
                                    <label for="quick-sitemap-post-type-<?php echo esc_attr($post_type->name); ?>"><?php echo esc_html($post_type->labels->name); ?></label>
                                </th>
                                <td>
                                    <label>
                                        <input type="checkbox" id="quick-sitemap-post-type-<?php echo esc_attr($post_type->name); ?>" name="quick_sitemap_options[sitemap_items][<?php echo esc_attr($post_type->name); ?>]" value="1" <?php checked(isset($options['sitemap_items'][$post_type->name]) ? $options['sitemap_items'][$post_type->name] : true); ?>>
                                        <?php printf(esc_html__('Include %s in sitemap', 'quick-sitemap'), esc_html($post_type->labels->name)); ?>
                                    </label>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                    
                    <h3><?php esc_html_e('Taxonomies', 'quick-sitemap'); ?></h3>
                    <p><?php esc_html_e('Select which taxonomies to include in the sitemap:', 'quick-sitemap'); ?></p>
                    
                    <table class="form-table">
                        <?php foreach ($taxonomies as $taxonomy) : ?>
                            <tr>
                                <th scope="row">
                                    <label for="quick-sitemap-taxonomy-<?php echo esc_attr($taxonomy->name); ?>"><?php echo esc_html($taxonomy->labels->name); ?></label>
                                </th>
                                <td>
                                    <label>
                                        <input type="checkbox" id="quick-sitemap-taxonomy-<?php echo esc_attr($taxonomy->name); ?>" name="quick_sitemap_options[sitemap_taxonomies][<?php echo esc_attr($taxonomy->name); ?>]" value="1" <?php checked(isset($options['sitemap_taxonomies'][$taxonomy->name]) ? $options['sitemap_taxonomies'][$taxonomy->name] : true); ?>>
                                        <?php printf(esc_html__('Include %s in sitemap', 'quick-sitemap'), esc_html($taxonomy->labels->name)); ?>
                                    </label>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                
                <div id="advanced-settings" class="quick-sitemap-tab-pane">
                    <h2><?php esc_html_e('Advanced Settings', 'quick-sitemap'); ?></h2>
                    
                    <h3><?php esc_html_e('Priority Settings', 'quick-sitemap'); ?></h3>
                    <p><?php esc_html_e('Set the relative priority for different content types (0.0 to 1.0):', 'quick-sitemap'); ?></p>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row">
                                <label for="quick-sitemap-priority-home"><?php esc_html_e('Homepage', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <input type="number" step="0.1" min="0" max="1" id="quick-sitemap-priority-home" name="quick_sitemap_options[sitemap_priority][home]" value="<?php echo esc_attr(isset($options['sitemap_priority']['home']) ? $options['sitemap_priority']['home'] : '1.0'); ?>" class="small-text">
                            </td>
                        </tr>
                        
                        <?php foreach ($post_types as $post_type) : ?>
                            <tr>
                                <th scope="row">
                                    <label for="quick-sitemap-priority-<?php echo esc_attr($post_type->name); ?>"><?php echo esc_html($post_type->labels->name); ?></label>
                                </th>
                                <td>
                                    <input type="number" step="0.1" min="0" max="1" id="quick-sitemap-priority-<?php echo esc_attr($post_type->name); ?>" name="quick_sitemap_options[sitemap_priority][<?php echo esc_attr($post_type->name); ?>]" value="<?php echo esc_attr(isset($options['sitemap_priority'][$post_type->name]) ? $options['sitemap_priority'][$post_type->name] : '0.7'); ?>" class="small-text">
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        
                        <?php foreach ($taxonomies as $taxonomy) : ?>
                            <tr>
                                <th scope="row">
                                    <label for="quick-sitemap-priority-<?php echo esc_attr($taxonomy->name); ?>"><?php echo esc_html($taxonomy->labels->name); ?></label>
                                </th>
                                <td>
                                    <input type="number" step="0.1" min="0" max="1" id="quick-sitemap-priority-<?php echo esc_attr($taxonomy->name); ?>" name="quick_sitemap_options[sitemap_priority][<?php echo esc_attr($taxonomy->name); ?>]" value="<?php echo esc_attr(isset($options['sitemap_priority'][$taxonomy->name]) ? $options['sitemap_priority'][$taxonomy->name] : '0.5'); ?>" class="small-text">
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        
                        <tr>
                            <th scope="row">
                                <label for="quick-sitemap-priority-author"><?php esc_html_e('Author Archives', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <input type="number" step="0.1" min="0" max="1" id="quick-sitemap-priority-author" name="quick_sitemap_options[sitemap_priority][author]" value="<?php echo esc_attr(isset($options['sitemap_priority']['author']) ? $options['sitemap_priority']['author'] : '0.3'); ?>" class="small-text">
                            </td>
                        </tr>
                    </table>
                    
                    <h3><?php esc_html_e('Change Frequency', 'quick-sitemap'); ?></h3>
                    <p><?php esc_html_e('Set how frequently the content is likely to change:', 'quick-sitemap'); ?></p>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row">
                                <label for="quick-sitemap-frequency-home"><?php esc_html_e('Homepage', 'quick-sitemap'); ?></label>
                            </th>
                            <td>
                                <select id="quick-sitemap-frequency-home" name="quick_sitemap_options[sitemap_frequency][home]">
                                    <option value="always" <?php selected(isset($options['sitemap_frequency']['home']) ? $options['sitemap_frequency']['home'] : 'daily', 'always'); ?>><?php esc_html_e('Always', 'quick-sitemap'); ?></option>
                                    <option value="hourly" <?php selected(isset($options['sitemap_frequency']['home']) ? $options['sitemap_frequency']['home'] : 'daily', 'hourly'); ?>><?php esc_html_e('Hourly', 'quick-sitemap'); ?></option>
                                    <option value="daily" <?php selected(isset($options['sitemap_frequency']['home']) ? $options['sitemap_frequency']['home'] : 'daily', 'daily'); ?>><?php esc_html_e('Daily', 'quick-sitemap'); ?></option>
                                    <option value="weekly" <?php selected(isset($options['sitemap_frequency']['home']) ? $options['sitemap_frequency']['home'] : 'daily', 'weekly'); ?>><?php esc_html_e('Weekly', 'quick-sitemap'); ?></option>
                                    <option value="monthly" <?php selected(isset($options['sitemap_frequency']['home']) ? $options['sitemap_frequency']['home'] : 'daily', 'monthly'); ?>><?php esc_html_e('Monthly', 'quick-sitemap'); ?></option>
                                    <option value="yearly" <?php selected(isset($options['sitemap_frequency']['home']) ? $options['sitemap_frequency']['home'] : 'daily', 'yearly'); ?>><?php esc_html_e('Yearly', 'quick-sitemap'); ?></option>
                                    <option value="never" <?php selected(isset($options['sitemap_frequency']['home']) ? $options['sitemap_frequency']['home'] : 'daily', 'never'); ?>><?php esc_html_e('Never', 'quick-sitemap'); ?></option>
                                </select>
                            </td>
                        </tr>
                        
                        <?php foreach ($post_types as $post_type) : ?>
                            <tr>
                                <th scope="row">
                                    <label for="quick-sitemap-frequency-<?php echo esc_attr($post_type->name); ?>"><?php echo esc_html($post_type->labels->name); ?></label>
                                </th>
                                <td>
                                    <select id="quick-sitemap-frequency-<?php echo esc_attr($post_type->name); ?>" name="quick_sitemap_options[sitemap_frequency][<?php echo esc_attr($post_type->name); ?>]">
                                        <option value="always" <?php selected(isset($options['sitemap_frequency'][$post_type->name]) ? $options['sitemap_frequency'][$post_type->name] : 'weekly', 'always'); ?>><?php esc_html_e('Always', 'quick-sitemap'); ?></option>
                                        <option value="hourly" <?php selected(isset($options['sitemap_frequency'][$post_type->name]) ? $options['sitemap_frequency'][$post_type->name] : 'weekly', 'hourly'); ?>><?php esc_html_e('Hourly', 'quick-sitemap'); ?></option>
                                        <option value="daily" <?php selected(isset($options['sitemap_frequency'][$post_type->name]) ? $options['sitemap_frequency'][$post_type->name] : 'weekly', 'daily'); ?>><?php esc_html_e('Daily', 'quick-sitemap'); ?></option>
                                        <option value="weekly" <?php selected(isset($options['sitemap_frequency'][$post_type->name]) ? $options['sitemap_frequency'][$post_type->name] : 'weekly', 'weekly'); ?>><?php esc_html_e('Weekly', 'quick-sitemap'); ?></option>
                                        <option value="monthly" <?php selected(isset($options['sitemap_frequency'][$post_type->name]) ? $options['sitemap_frequency'][$post_type->name] : 'weekly', 'monthly'); ?>><?php esc_html_e('Monthly', 'quick-sitemap'); ?></option>
                                        <option value="yearly" <?php selected(isset($options['sitemap_frequency'][$post_type->name]) ? $options['sitemap_frequency'][$post_type->name] : 'weekly', 'yearly'); ?>><?php esc_html_e('Yearly', 'quick-sitemap'); ?></option>
                                        <option value="never" <?php selected(isset($options['sitemap_frequency'][$post_type->name]) ? $options['sitemap_frequency'][$post_type->name] : 'weekly', 'never'); ?>><?php esc_html_e('Never', 'quick-sitemap'); ?></option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                
                <?php if (isset($options['sitemap_google_news']) && $options['sitemap_google_news']) : ?>
                    <div id="news-settings" class="quick-sitemap-tab-pane">
                        <h2><?php esc_html_e('Google News Settings', 'quick-sitemap'); ?></h2>
                        
                        <p><?php esc_html_e('These settings apply to the Google News sitemap. Your site must be approved for Google News for this to work.', 'quick-sitemap'); ?></p>
                        
                        <table class="form-table">
                            <tr>
                                <th scope="row">
                                    <label for="quick-sitemap-news-name"><?php esc_html_e('Publication Name', 'quick-sitemap'); ?></label>
                                </th>
                                <td>
                                    <input type="text" id="quick-sitemap-news-name" name="quick_sitemap_options[sitemap_news_name]" value="<?php echo esc_attr(isset($options['sitemap_news_name']) ? $options['sitemap_news_name'] : get_bloginfo('name')); ?>" class="regular-text">
                                    <p class="description"><?php esc_html_e('The name of your publication as it appears in Google News.', 'quick-sitemap'); ?></p>
                                </td>
                            </tr>
                            
                            <tr>
                                <th scope="row">
                                    <label><?php esc_html_e('Post Types', 'quick-sitemap'); ?></label>
                                </th>
                                <td>
                                    <?php foreach ($post_types as $post_type) : ?>
                                        <label>
                                            <input type="checkbox" name="quick_sitemap_options[sitemap_news_post_types][<?php echo esc_attr($post_type->name); ?>]" value="1" <?php checked(isset($options['sitemap_news_post_types'][$post_type->name]) ? $options['sitemap_news_post_types'][$post_type->name] : ($post_type->name === 'post')); ?>>
                                            <?php echo esc_html($post_type->labels->name); ?>
                                        </label>
                                        <br>
                                    <?php endforeach; ?>
                                    <p class="description"><?php esc_html_e('Select which post types to include in the Google News sitemap.', 'quick-sitemap'); ?></p>
                                </td>
                            </tr>
                        </table>
                    </div>
                <?php endif; ?>
                
                <?php submit_button(); ?>
            </form>
        </div>
    </div>
</div>
