/**
 * All of the JavaScript for your admin-specific functionality should be
 * included in this file.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Sitemap
 * @subpackage Quick_Sitemap/admin/js
 */

(function($) {
    'use strict';

    /**
     * Initialize the admin JavaScript
     */
    $(function() {
        // Tab navigation
        $('.quick-sitemap-tab-nav a').on('click', function(e) {
            e.preventDefault();
            
            // Get the target tab
            var target = $(this).attr('href');
            
            // Remove active class from all tabs and panes
            $('.quick-sitemap-tab-nav li').removeClass('active');
            $('.quick-sitemap-tab-pane').removeClass('active');
            
            // Add active class to the clicked tab and corresponding pane
            $(this).parent().addClass('active');
            $(target).addClass('active');
        });
        
        // Regenerate sitemap
        $('#quick-sitemap-regenerate').on('click', function(e) {
            e.preventDefault();
            
            // Show loading indicator
            var $button = $(this);
            $button.addClass('quick-sitemap-loading');
            
            // Clear any previous notices
            $('#quick-sitemap-notice').hide().removeClass('notice-success notice-error').empty();
            
            // Send AJAX request
            $.ajax({
                url: quick_sitemap_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'quick_sitemap_regenerate',
                    nonce: quick_sitemap_params.nonce
                },
                success: function(response) {
                    $button.removeClass('quick-sitemap-loading');
                    
                    if (response.success) {
                        $('#quick-sitemap-notice')
                            .addClass('notice-success')
                            .html('<p>' + response.data.message + '</p>')
                            .show();
                            
                        // Update last generated time if provided
                        if (response.data.last_generated) {
                            $('.quick-sitemap-last-generated p').text('Last generated: ' + response.data.last_generated);
                        }
                    } else {
                        $('#quick-sitemap-notice')
                            .addClass('notice-error')
                            .html('<p>' + response.data.message + '</p>')
                            .show();
                    }
                },
                error: function() {
                    $button.removeClass('quick-sitemap-loading');
                    
                    $('#quick-sitemap-notice')
                        .addClass('notice-error')
                        .html('<p>An error occurred while regenerating the sitemap. Please try again.</p>')
                        .show();
                }
            });
        });
        
        // Ping search engines
        $('#quick-sitemap-ping').on('click', function(e) {
            e.preventDefault();
            
            // Show loading indicator
            var $button = $(this);
            $button.addClass('quick-sitemap-loading');
            
            // Clear any previous notices
            $('#quick-sitemap-notice').hide().removeClass('notice-success notice-error').empty();
            
            // Send AJAX request
            $.ajax({
                url: quick_sitemap_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'quick_sitemap_ping',
                    nonce: quick_sitemap_params.nonce
                },
                success: function(response) {
                    $button.removeClass('quick-sitemap-loading');
                    
                    if (response.success) {
                        $('#quick-sitemap-notice')
                            .addClass('notice-success')
                            .html('<p>' + response.data.message + '</p>')
                            .show();
                    } else {
                        $('#quick-sitemap-notice')
                            .addClass('notice-error')
                            .html('<p>' + response.data.message + '</p>')
                            .show();
                    }
                },
                error: function() {
                    $button.removeClass('quick-sitemap-loading');
                    
                    $('#quick-sitemap-notice')
                        .addClass('notice-error')
                        .html('<p>An error occurred while pinging search engines. Please try again.</p>')
                        .show();
                }
            });
        });
        
        // Toggle Google News settings
        $('input[name="quick_sitemap_options[sitemap_google_news]"]').on('change', function() {
            if ($(this).is(':checked')) {
                // If Google News is enabled, check if the tab exists
                if ($('#news-settings').length === 0) {
                    // Add the Google News tab
                    $('.quick-sitemap-tab-nav').append(
                        '<li><a href="#news-settings">' + quick_sitemap_params.i18n.google_news + '</a></li>'
                    );
                    
                    // Add the Google News tab content
                    var newsTabContent = 
                        '<div id="news-settings" class="quick-sitemap-tab-pane">' +
                            '<h2>' + quick_sitemap_params.i18n.google_news_settings + '</h2>' +
                            '<p>' + quick_sitemap_params.i18n.google_news_description + '</p>' +
                            '<table class="form-table">' +
                                '<tr>' +
                                    '<th scope="row">' +
                                        '<label for="quick-sitemap-news-name">' + quick_sitemap_params.i18n.publication_name + '</label>' +
                                    '</th>' +
                                    '<td>' +
                                        '<input type="text" id="quick-sitemap-news-name" name="quick_sitemap_options[sitemap_news_name]" value="' + quick_sitemap_params.site_name + '" class="regular-text">' +
                                        '<p class="description">' + quick_sitemap_params.i18n.publication_name_desc + '</p>' +
                                    '</td>' +
                                '</tr>' +
                                '<tr>' +
                                    '<th scope="row">' +
                                        '<label>' + quick_sitemap_params.i18n.post_types + '</label>' +
                                    '</th>' +
                                    '<td id="quick-sitemap-news-post-types">' +
                                        // Post types will be added dynamically
                                    '</td>' +
                                '</tr>' +
                            '</table>' +
                        '</div>';
                    
                    $('.quick-sitemap-tab-content form').append(newsTabContent);
                    
                    // Add post types to the Google News settings
                    var postTypes = quick_sitemap_params.post_types;
                    var postTypesHtml = '';
                    
                    $.each(postTypes, function(name, label) {
                        var checked = name === 'post' ? ' checked="checked"' : '';
                        postTypesHtml += 
                            '<label>' +
                                '<input type="checkbox" name="quick_sitemap_options[sitemap_news_post_types][' + name + ']" value="1"' + checked + '>' +
                                label +
                            '</label>' +
                            '<br>';
                    });
                    
                    postTypesHtml += '<p class="description">' + quick_sitemap_params.i18n.news_post_types_desc + '</p>';
                    $('#quick-sitemap-news-post-types').html(postTypesHtml);
                } else {
                    // Show the Google News tab
                    $('#news-settings').show();
                    $('.quick-sitemap-tab-nav li a[href="#news-settings"]').parent().show();
                }
            } else {
                // Hide the Google News tab
                $('#news-settings').hide();
                $('.quick-sitemap-tab-nav li a[href="#news-settings"]').parent().hide();
            }
        });
        
        // Trigger change event on page load to initialize the Google News tab
        $('input[name="quick_sitemap_options[sitemap_google_news]"]').trigger('change');
    });

})(jQuery);
