# Quick Sitemap

A powerful WordPress plugin that generates XML and Google News sitemaps to improve your site's SEO.

## Description

Quick Sitemap is a comprehensive sitemap solution for WordPress that helps search engines discover and index your content more efficiently. It creates XML sitemaps that comply with the sitemaps.org protocol and provides additional features for image, video, and Google News sitemaps.

### Features

* **XML Sitemap Generation**: Automatically creates XML sitemaps for all your content.
* **Google News Sitemap**: Creates a specialized sitemap for sites approved for Google News.
* **Image & Video Sitemaps**: Includes image and video information in your sitemaps.
* **Multilingual Support**: Compatible with WPML and Polylang for multilingual websites.
* **Search Engine Pinging**: Automatically notifies search engines when your content changes.
* **Priority & Frequency Control**: Set custom priority and change frequency for different content types.
* **User-friendly Interface**: Easy-to-use admin interface for managing sitemap settings.
* **Human-readable Sitemaps**: Includes an XSL stylesheet to make sitemaps human-readable in browsers.

## Installation

1. Upload the `quick-sitemap` folder to the `/wp-content/plugins/` directory.
2. Activate the plugin through the 'Plugins' menu in WordPress.
3. Go to 'Settings > Quick Sitemap' to configure the plugin.

## Frequently Asked Questions

### Where can I find my sitemap?

Your main sitemap index is available at `https://yourdomain.com/sitemap.xml`.

### Does this plugin support Google News sitemaps?

Yes, Quick Sitemap supports Google News sitemaps. You need to enable this feature in the plugin settings. Note that your site must be approved for Google News for this feature to be useful.

### Can I exclude specific content from my sitemap?

Yes, you can choose which post types and taxonomies to include in your sitemap from the plugin settings.

### Will this plugin slow down my website?

No, Quick Sitemap is designed to be lightweight and efficient. Sitemaps are generated on-demand and cached to minimize performance impact.

### How do I submit my sitemap to search engines?

You can submit your sitemap to search engines through their webmaster tools:
- [Google Search Console](https://search.google.com/search-console)
- [Bing Webmaster Tools](https://www.bing.com/webmasters)

The plugin also includes an option to automatically ping search engines when your content changes.

### Is this plugin compatible with multilingual websites?

Yes, Quick Sitemap is compatible with WPML and Polylang for multilingual websites.

## Screenshots

1. Main settings page
2. Content settings
3. Advanced settings
4. Google News settings
5. Sitemap view

## Changelog

### 1.0.0
* Initial release

## Upgrade Notice

### 1.0.0
Initial release

## Credits

Quick Sitemap is developed and maintained by [Quick Plugins](https://example.com).

## License

This plugin is licensed under the GPL v2 or later.

```
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
```
