<?php
/**
 * Plugin Name: Quick Push Notifications
 * Plugin URI: https://plugins.quickpr.co/quick-push-notifications
 * Description: Self-hosted push notifications for WordPress using Firebase Cloud Messaging and Web Push API.
 * Version: 1.0.0
 * Author: Quick LLC
 * Author URI: https://plugins.quickpr.co/
 * Text Domain: quick-push-notifications
 * Domain Path: /languages
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @package Quick_Push_Notifications
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

/**
 * Current plugin version.
 */
define( 'QUICK_PUSH_NOTIFICATIONS_VERSION', '1.0.0' );
define( 'QUICK_PUSH_NOTIFICATIONS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'QUICK_PUSH_NOTIFICATIONS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'QUICK_PUSH_NOTIFICATIONS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 */
function activate_quick_push_notifications() {
    require_once QUICK_PUSH_NOTIFICATIONS_PLUGIN_DIR . 'includes/class-quick-push-notifications-activator.php';
    Quick_Push_Notifications_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_quick_push_notifications() {
    require_once QUICK_PUSH_NOTIFICATIONS_PLUGIN_DIR . 'includes/class-quick-push-notifications-deactivator.php';
    Quick_Push_Notifications_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_quick_push_notifications' );
register_deactivation_hook( __FILE__, 'deactivate_quick_push_notifications' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require QUICK_PUSH_NOTIFICATIONS_PLUGIN_DIR . 'includes/class-quick-push-notifications.php';

/**
 * Begins execution of the plugin.
 *
 * @since    1.0.0
 */
function run_quick_push_notifications() {
    $plugin = new Quick_Push_Notifications();
    $plugin->run();
}
run_quick_push_notifications();
