<?php
/**
 * Provide a public-facing view for the subscription dialog
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Push_Notifications
 * @subpackage Quick_Push_Notifications/public/partials
 */
?>

<!-- Subscription Dialog -->
<div id="qpn-subscription-dialog" class="qpn-dialog" style="display: none;">
    <div class="qpn-dialog-content">
        <div class="qpn-dialog-header">
            <h3 id="qpn-dialog-title"><?php _e('Subscribe to Notifications', 'quick-push-notifications'); ?></h3>
            <span class="qpn-dialog-close">&times;</span>
        </div>
        <div class="qpn-dialog-body">
            <p id="qpn-dialog-text"><?php _e('Would you like to receive notifications from this website?', 'quick-push-notifications'); ?></p>
            <div id="qpn-permission-denied" style="display: none;">
                <p><?php _e('You have denied notification permission. Please enable notifications in your browser settings to receive notifications from this website.', 'quick-push-notifications'); ?></p>
                <div class="qpn-browser-instructions">
                    <div class="qpn-instruction-chrome">
                        <h4><?php _e('Chrome Instructions:', 'quick-push-notifications'); ?></h4>
                        <ol>
                            <li><?php _e('Click the lock icon in the address bar', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Click "Site settings"', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Find "Notifications" and change it to "Allow"', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Refresh the page', 'quick-push-notifications'); ?></li>
                        </ol>
                    </div>
                    <div class="qpn-instruction-firefox">
                        <h4><?php _e('Firefox Instructions:', 'quick-push-notifications'); ?></h4>
                        <ol>
                            <li><?php _e('Click the lock icon in the address bar', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Click the gear icon next to "Connection secure"', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Find "Notifications" and change it to "Allow"', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Refresh the page', 'quick-push-notifications'); ?></li>
                        </ol>
                    </div>
                    <div class="qpn-instruction-safari">
                        <h4><?php _e('Safari Instructions:', 'quick-push-notifications'); ?></h4>
                        <ol>
                            <li><?php _e('Click Safari in the menu bar', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Click Preferences', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Go to the Websites tab', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Click Notifications', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Find this website and change it to "Allow"', 'quick-push-notifications'); ?></li>
                            <li><?php _e('Refresh the page', 'quick-push-notifications'); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="qpn-dialog-footer">
            <button id="qpn-dialog-cancel" class="qpn-btn qpn-btn-secondary"><?php _e('No, Thanks', 'quick-push-notifications'); ?></button>
            <button id="qpn-dialog-confirm" class="qpn-btn qpn-btn-primary"><?php _e('Yes, Subscribe', 'quick-push-notifications'); ?></button>
        </div>
    </div>
</div>

<!-- Subscription Button -->
<div id="qpn-subscription-button-container" style="display: none;">
    <button id="qpn-subscription-button" class="qpn-btn qpn-btn-primary">
        <span id="qpn-subscribe-text"><?php _e('Subscribe to Notifications', 'quick-push-notifications'); ?></span>
        <span id="qpn-unsubscribe-text" style="display: none;"><?php _e('Unsubscribe from Notifications', 'quick-push-notifications'); ?></span>
    </button>
</div>

<style>
/* Dialog */
.qpn-dialog {
    display: none;
    position: fixed;
    z-index: 9999;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.4);
}

.qpn-dialog-content {
    background-color: #fefefe;
    margin: 10% auto;
    padding: 0;
    border: 1px solid #ddd;
    border-radius: 5px;
    width: 90%;
    max-width: 500px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.qpn-dialog-header {
    padding: 15px 20px;
    border-bottom: 1px solid #f0f0f0;
    position: relative;
}

.qpn-dialog-header h3 {
    margin: 0;
    font-size: 18px;
}

.qpn-dialog-close {
    position: absolute;
    right: 20px;
    top: 15px;
    color: #aaa;
    font-size: 24px;
    font-weight: bold;
    cursor: pointer;
}

.qpn-dialog-close:hover,
.qpn-dialog-close:focus {
    color: black;
    text-decoration: none;
    cursor: pointer;
}

.qpn-dialog-body {
    padding: 20px;
}

.qpn-dialog-footer {
    padding: 15px 20px;
    border-top: 1px solid #f0f0f0;
    text-align: right;
}

/* Buttons */
.qpn-btn {
    display: inline-block;
    font-weight: 400;
    text-align: center;
    white-space: nowrap;
    vertical-align: middle;
    user-select: none;
    border: 1px solid transparent;
    padding: 0.375rem 0.75rem;
    font-size: 14px;
    line-height: 1.5;
    border-radius: 0.25rem;
    transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
    cursor: pointer;
}

.qpn-btn-primary {
    color: #fff;
    background-color: #0073aa;
    border-color: #0073aa;
}

.qpn-btn-primary:hover {
    background-color: #006291;
    border-color: #005984;
}

.qpn-btn-secondary {
    color: #333;
    background-color: #f8f9fa;
    border-color: #ddd;
}

.qpn-btn-secondary:hover {
    background-color: #e9ecef;
    border-color: #ccc;
}

/* Subscription Button */
#qpn-subscription-button-container {
    margin: 15px 0;
}

#qpn-subscription-button {
    display: inline-block;
}

/* Browser Instructions */
.qpn-browser-instructions {
    margin-top: 15px;
    border-top: 1px solid #eee;
    padding-top: 15px;
}

.qpn-browser-instructions h4 {
    margin-top: 0;
    margin-bottom: 10px;
}

.qpn-browser-instructions ol {
    margin-left: 20px;
    padding-left: 0;
}

.qpn-browser-instructions li {
    margin-bottom: 5px;
}

/* Responsive */
@media (max-width: 576px) {
    .qpn-dialog-content {
        width: 95%;
        margin: 5% auto;
    }
}
</style>
