<?php
/**
 * Provide a admin area view for managing subscribers
 *
 * This file is used to markup the admin-facing subscribers page.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Push_Notifications
 * @subpackage Quick_Push_Notifications/admin/partials
 */
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="qpn-subscribers-container">
        <!-- Filters -->
        <div class="qpn-subscribers-filters">
            <div class="qpn-filters-row">
                <div class="qpn-filter">
                    <input type="text" id="qpn_subscriber_search" placeholder="<?php _e('Search subscribers...', 'quick-push-notifications'); ?>">
                </div>
                <div class="qpn-filter">
                    <select id="qpn_browser_filter">
                        <option value=""><?php _e('All Browsers', 'quick-push-notifications'); ?></option>
                        <option value="Chrome"><?php _e('Chrome', 'quick-push-notifications'); ?></option>
                        <option value="Firefox"><?php _e('Firefox', 'quick-push-notifications'); ?></option>
                        <option value="Safari"><?php _e('Safari', 'quick-push-notifications'); ?></option>
                        <option value="Edge"><?php _e('Edge', 'quick-push-notifications'); ?></option>
                        <option value="Opera"><?php _e('Opera', 'quick-push-notifications'); ?></option>
                    </select>
                </div>
                <div class="qpn-filter">
                    <select id="qpn_os_filter">
                        <option value=""><?php _e('All OS', 'quick-push-notifications'); ?></option>
                        <option value="Windows"><?php _e('Windows', 'quick-push-notifications'); ?></option>
                        <option value="Mac OS"><?php _e('Mac OS', 'quick-push-notifications'); ?></option>
                        <option value="Linux"><?php _e('Linux', 'quick-push-notifications'); ?></option>
                        <option value="Android"><?php _e('Android', 'quick-push-notifications'); ?></option>
                        <option value="iOS"><?php _e('iOS', 'quick-push-notifications'); ?></option>
                    </select>
                </div>
                <div class="qpn-filter">
                    <select id="qpn_device_filter">
                        <option value=""><?php _e('All Devices', 'quick-push-notifications'); ?></option>
                        <option value="Desktop"><?php _e('Desktop', 'quick-push-notifications'); ?></option>
                        <option value="Mobile"><?php _e('Mobile', 'quick-push-notifications'); ?></option>
                        <option value="Tablet"><?php _e('Tablet', 'quick-push-notifications'); ?></option>
                    </select>
                </div>
                <div class="qpn-filter">
                    <button id="qpn_apply_filters" class="button"><?php _e('Apply Filters', 'quick-push-notifications'); ?></button>
                    <button id="qpn_reset_filters" class="button"><?php _e('Reset', 'quick-push-notifications'); ?></button>
                </div>
            </div>
        </div>
        
        <!-- Subscribers Table -->
        <div class="qpn-subscribers-table-container">
            <table class="wp-list-table widefat fixed striped qpn-subscribers-table">
                <thead>
                    <tr>
                        <th class="column-id"><?php _e('ID', 'quick-push-notifications'); ?></th>
                        <th class="column-browser"><?php _e('Browser', 'quick-push-notifications'); ?></th>
                        <th class="column-os"><?php _e('OS', 'quick-push-notifications'); ?></th>
                        <th class="column-device"><?php _e('Device', 'quick-push-notifications'); ?></th>
                        <th class="column-ip"><?php _e('IP Address', 'quick-push-notifications'); ?></th>
                        <th class="column-date"><?php _e('Subscribed', 'quick-push-notifications'); ?></th>
                        <th class="column-last-activity"><?php _e('Last Activity', 'quick-push-notifications'); ?></th>
                        <th class="column-actions"><?php _e('Actions', 'quick-push-notifications'); ?></th>
                    </tr>
                </thead>
                <tbody id="qpn_subscribers_list">
                    <!-- Subscriber rows will be loaded via AJAX -->
                    <tr class="qpn-loading-row">
                        <td colspan="8"><?php _e('Loading subscribers...', 'quick-push-notifications'); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <div class="qpn-pagination">
            <div class="qpn-pagination-info">
                <span id="qpn_pagination_info"><?php _e('Loading...', 'quick-push-notifications'); ?></span>
            </div>
            <div class="qpn-pagination-controls">
                <button id="qpn_prev_page" class="button" disabled><?php _e('Previous', 'quick-push-notifications'); ?></button>
                <span id="qpn_current_page">1</span>
                <button id="qpn_next_page" class="button" disabled><?php _e('Next', 'quick-push-notifications'); ?></button>
            </div>
        </div>
        
        <!-- Export/Import -->
        <div class="qpn-export-import">
            <h3><?php _e('Export/Import', 'quick-push-notifications'); ?></h3>
            <div class="qpn-export-import-buttons">
                <button id="qpn_export_subscribers" class="button"><?php _e('Export Subscribers (CSV)', 'quick-push-notifications'); ?></button>
            </div>
        </div>
        
        <!-- Test Notification -->
        <div class="qpn-test-notification">
            <h3><?php _e('Send Test Notification', 'quick-push-notifications'); ?></h3>
            <p><?php _e('Send a test notification to all subscribers to verify your setup.', 'quick-push-notifications'); ?></p>
            <div class="qpn-test-notification-form">
                <input type="text" id="qpn_test_title" placeholder="<?php _e('Test Notification Title', 'quick-push-notifications'); ?>" value="<?php _e('Test Notification', 'quick-push-notifications'); ?>">
                <input type="text" id="qpn_test_message" placeholder="<?php _e('Test Notification Message', 'quick-push-notifications'); ?>" value="<?php _e('This is a test notification from your website.', 'quick-push-notifications'); ?>">
                <button id="qpn_send_test" class="button button-primary"><?php _e('Send Test Notification', 'quick-push-notifications'); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Subscriber Details Modal -->
<div id="qpn_subscriber_modal" class="qpn-modal">
    <div class="qpn-modal-content">
        <span class="qpn-modal-close">&times;</span>
        <h2><?php _e('Subscriber Details', 'quick-push-notifications'); ?></h2>
        <div id="qpn_subscriber_details">
            <!-- Subscriber details will be loaded via AJAX -->
        </div>
    </div>
</div>

<style>
/* Subscribers Table */
.qpn-subscribers-container {
    margin-top: 20px;
}

.qpn-subscribers-filters {
    background: #fff;
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    padding: 15px;
}

.qpn-filters-row {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    align-items: center;
}

.qpn-filter {
    margin-bottom: 10px;
}

.qpn-subscribers-table-container {
    background: #fff;
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    overflow-x: auto;
}

.qpn-subscribers-table {
    width: 100%;
}

.qpn-subscribers-table .column-id {
    width: 50px;
}

.qpn-subscribers-table .column-browser,
.qpn-subscribers-table .column-os,
.qpn-subscribers-table .column-device {
    width: 100px;
}

.qpn-subscribers-table .column-ip {
    width: 120px;
}

.qpn-subscribers-table .column-date,
.qpn-subscribers-table .column-last-activity {
    width: 150px;
}

.qpn-subscribers-table .column-actions {
    width: 100px;
    text-align: right;
}

.qpn-loading-row td {
    text-align: center;
    padding: 20px;
}

/* Pagination */
.qpn-pagination {
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: #fff;
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    padding: 10px 15px;
}

.qpn-pagination-controls {
    display: flex;
    align-items: center;
    gap: 10px;
}

/* Export/Import */
.qpn-export-import {
    background: #fff;
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    padding: 15px;
}

.qpn-export-import h3 {
    margin-top: 0;
}

/* Test Notification */
.qpn-test-notification {
    background: #fff;
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    padding: 15px;
}

.qpn-test-notification h3 {
    margin-top: 0;
}

.qpn-test-notification-form {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    align-items: center;
}

.qpn-test-notification-form input {
    flex: 1;
    min-width: 200px;
}

/* Modal */
.qpn-modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.4);
}

.qpn-modal-content {
    background-color: #fefefe;
    margin: 10% auto;
    padding: 20px;
    border: 1px solid #ddd;
    border-radius: 5px;
    width: 80%;
    max-width: 600px;
    position: relative;
}

.qpn-modal-close {
    color: #aaa;
    float: right;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
}

.qpn-modal-close:hover,
.qpn-modal-close:focus {
    color: black;
    text-decoration: none;
    cursor: pointer;
}
</style>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Variables
    var currentPage = 1;
    var itemsPerPage = 20;
    var totalItems = 0;
    var totalPages = 0;
    var searchTerm = '';
    var browserFilter = '';
    var osFilter = '';
    var deviceFilter = '';
    
    // Load subscribers on page load
    loadSubscribers();
    
    // Apply filters
    $('#qpn_apply_filters').click(function() {
        searchTerm = $('#qpn_subscriber_search').val();
        browserFilter = $('#qpn_browser_filter').val();
        osFilter = $('#qpn_os_filter').val();
        deviceFilter = $('#qpn_device_filter').val();
        currentPage = 1;
        loadSubscribers();
    });
    
    // Reset filters
    $('#qpn_reset_filters').click(function() {
        $('#qpn_subscriber_search').val('');
        $('#qpn_browser_filter').val('');
        $('#qpn_os_filter').val('');
        $('#qpn_device_filter').val('');
        searchTerm = '';
        browserFilter = '';
        osFilter = '';
        deviceFilter = '';
        currentPage = 1;
        loadSubscribers();
    });
    
    // Pagination
    $('#qpn_prev_page').click(function() {
        if (currentPage > 1) {
            currentPage--;
            loadSubscribers();
        }
    });
    
    $('#qpn_next_page').click(function() {
        if (currentPage < totalPages) {
            currentPage++;
            loadSubscribers();
        }
    });
    
    // Export subscribers
    $('#qpn_export_subscribers').click(function() {
        window.location.href = ajaxurl + '?action=qpn_export_subscribers&nonce=' + '<?php echo wp_create_nonce('qpn_admin_nonce'); ?>';
    });
    
    // Send test notification
    $('#qpn_send_test').click(function() {
        var title = $('#qpn_test_title').val();
        var message = $('#qpn_test_message').val();
        
        if (!title || !message) {
            alert('<?php _e('Please enter both title and message for the test notification.', 'quick-push-notifications'); ?>');
            return;
        }
        
        $(this).prop('disabled', true).text('<?php _e('Sending...', 'quick-push-notifications'); ?>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'qpn_send_test_notification',
                nonce: '<?php echo wp_create_nonce('qpn_admin_nonce'); ?>',
                title: title,
                message: message
            },
            success: function(response) {
                if (response.success) {
                    alert(response.data.message);
                } else {
                    alert(response.data.message);
                }
                $('#qpn_send_test').prop('disabled', false).text('<?php _e('Send Test Notification', 'quick-push-notifications'); ?>');
            },
            error: function() {
                alert('<?php _e('An error occurred while sending the test notification.', 'quick-push-notifications'); ?>');
                $('#qpn_send_test').prop('disabled', false).text('<?php _e('Send Test Notification', 'quick-push-notifications'); ?>');
            }
        });
    });
    
    // Modal
    $('.qpn-modal-close').click(function() {
        $('#qpn_subscriber_modal').hide();
    });
    
    $(window).click(function(event) {
        if ($(event.target).hasClass('qpn-modal')) {
            $('.qpn-modal').hide();
        }
    });
    
    // Load subscribers function
    function loadSubscribers() {
        $('#qpn_subscribers_list').html('<tr class="qpn-loading-row"><td colspan="8"><?php _e('Loading subscribers...', 'quick-push-notifications'); ?></td></tr>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'qpn_get_subscribers',
                nonce: '<?php echo wp_create_nonce('qpn_admin_nonce'); ?>',
                offset: (currentPage - 1) * itemsPerPage,
                limit: itemsPerPage,
                search: searchTerm,
                browser: browserFilter,
                os: osFilter,
                device_type: deviceFilter
            },
            success: function(response) {
                if (response.success) {
                    var subscribers = response.data.subscribers;
                    totalItems = response.data.total;
                    totalPages = Math.ceil(totalItems / itemsPerPage);
                    
                    // Update pagination info
                    var start = (currentPage - 1) * itemsPerPage + 1;
                    var end = Math.min(start + itemsPerPage - 1, totalItems);
                    
                    if (totalItems === 0) {
                        $('#qpn_pagination_info').text('<?php _e('No subscribers found', 'quick-push-notifications'); ?>');
                        $('#qpn_subscribers_list').html('<tr><td colspan="8"><?php _e('No subscribers found.', 'quick-push-notifications'); ?></td></tr>');
                    } else {
                        $('#qpn_pagination_info').text('<?php _e('Showing', 'quick-push-notifications'); ?> ' + start + ' <?php _e('to', 'quick-push-notifications'); ?> ' + end + ' <?php _e('of', 'quick-push-notifications'); ?> ' + totalItems + ' <?php _e('subscribers', 'quick-push-notifications'); ?>');
                        
                        // Update subscribers list
                        var html = '';
                        $.each(subscribers, function(index, subscriber) {
                            html += '<tr>';
                            html += '<td>' + subscriber.id + '</td>';
                            html += '<td>' + subscriber.browser + '</td>';
                            html += '<td>' + subscriber.os + '</td>';
                            html += '<td>' + subscriber.device_type + '</td>';
                            html += '<td>' + subscriber.ip_address + '</td>';
                            html += '<td>' + formatDate(subscriber.created_at) + '</td>';
                            html += '<td>' + formatDate(subscriber.last_activity) + '</td>';
                            html += '<td>';
                            html += '<button class="button button-small qpn-view-subscriber" data-id="' + subscriber.id + '"><?php _e('View', 'quick-push-notifications'); ?></button> ';
                            html += '<button class="button button-small qpn-delete-subscriber" data-id="' + subscriber.id + '"><?php _e('Delete', 'quick-push-notifications'); ?></button>';
                            html += '</td>';
                            html += '</tr>';
                        });
                        
                        $('#qpn_subscribers_list').html(html);
                    }
                    
                    // Update pagination controls
                    $('#qpn_current_page').text(currentPage);
                    $('#qpn_prev_page').prop('disabled', currentPage === 1);
                    $('#qpn_next_page').prop('disabled', currentPage === totalPages || totalPages === 0);
                    
                    // Bind events to new buttons
                    bindSubscriberActions();
                } else {
                    $('#qpn_subscribers_list').html('<tr><td colspan="8"><?php _e('Error loading subscribers.', 'quick-push-notifications'); ?></td></tr>');
                }
            },
            error: function() {
                $('#qpn_subscribers_list').html('<tr><td colspan="8"><?php _e('Error loading subscribers.', 'quick-push-notifications'); ?></td></tr>');
            }
        });
    }
    
    // Bind subscriber actions
    function bindSubscriberActions() {
        // View subscriber
        $('.qpn-view-subscriber').click(function() {
            var subscriberId = $(this).data('id');
            
            // Load subscriber details
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'qpn_get_subscriber_details',
                    nonce: '<?php echo wp_create_nonce('qpn_admin_nonce'); ?>',
                    subscriber_id: subscriberId
                },
                success: function(response) {
                    if (response.success) {
                        var subscriber = response.data.subscriber;
                        var html = '<table class="widefat">';
                        html += '<tr><th><?php _e('ID', 'quick-push-notifications'); ?></th><td>' + subscriber.id + '</td></tr>';
                        html += '<tr><th><?php _e('Browser', 'quick-push-notifications'); ?></th><td>' + subscriber.browser + '</td></tr>';
                        html += '<tr><th><?php _e('OS', 'quick-push-notifications'); ?></th><td>' + subscriber.os + '</td></tr>';
                        html += '<tr><th><?php _e('Device Type', 'quick-push-notifications'); ?></th><td>' + subscriber.device_type + '</td></tr>';
                        html += '<tr><th><?php _e('IP Address', 'quick-push-notifications'); ?></th><td>' + subscriber.ip_address + '</td></tr>';
                        html += '<tr><th><?php _e('Subscribed', 'quick-push-notifications'); ?></th><td>' + formatDate(subscriber.created_at) + '</td></tr>';
                        html += '<tr><th><?php _e('Last Activity', 'quick-push-notifications'); ?></th><td>' + formatDate(subscriber.last_activity) + '</td></tr>';
                        html += '<tr><th><?php _e('Endpoint', 'quick-push-notifications'); ?></th><td>' + subscriber.endpoint + '</td></tr>';
                        html += '</table>';
                        
                        $('#qpn_subscriber_details').html(html);
                        $('#qpn_subscriber_modal').show();
                    } else {
                        alert(response.data.message);
                    }
                },
                error: function() {
                    alert('<?php _e('Error loading subscriber details.', 'quick-push-notifications'); ?>');
                }
            });
        });
        
        // Delete subscriber
        $('.qpn-delete-subscriber').click(function() {
            if (!confirm('<?php _e('Are you sure you want to delete this subscriber?', 'quick-push-notifications'); ?>')) {
                return;
            }
            
            var subscriberId = $(this).data('id');
            var button = $(this);
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'qpn_delete_subscriber',
                    nonce: '<?php echo wp_create_nonce('qpn_admin_nonce'); ?>',
                    subscriber_id: subscriberId
                },
                beforeSend: function() {
                    button.prop('disabled', true).text('<?php _e('Deleting...', 'quick-push-notifications'); ?>');
                },
                success: function(response) {
                    if (response.success) {
                        // Reload subscribers
                        loadSubscribers();
                    } else {
                        alert(response.data.message);
                        button.prop('disabled', false).text('<?php _e('Delete', 'quick-push-notifications'); ?>');
                    }
                },
                error: function() {
                    alert('<?php _e('Error deleting subscriber.', 'quick-push-notifications'); ?>');
                    button.prop('disabled', false).text('<?php _e('Delete', 'quick-push-notifications'); ?>');
                }
            });
        });
    }
    
    // Format date
    function formatDate(dateString) {
        if (!dateString) return '';
        
        var date = new Date(dateString);
        return date.toLocaleDateString() + ' ' + date.toLocaleTimeString();
    }
});
</script>
