# Quick Push Notifications

A WordPress plugin that implements self-hosted push notifications using Firebase and the Web Push API.

## Description

Quick Push Notifications allows website owners to send push notifications to their visitors directly from their WordPress dashboard. Unlike SaaS solutions, this plugin is self-hosted, giving you complete control over your notification system with no subscriber limits or monthly fees.

### Features

- **Self-Hosted Push Notifications**: Full control over your notification system
- **Subscriber Management**: Track and manage your notification subscribers
- **Notification Composer**: Create and customize your push notifications
- **Scheduling**: Schedule notifications for future delivery
- **Auto-Push for New Content**: Automatically send notifications for new posts
- **Detailed Statistics**: View subscriber data and notification performance
- **Firebase Integration**: Powered by Firebase Cloud Messaging
- **Customizable**: Easily customize the appearance and behavior of notifications

## Installation

1. Upload the `quick-push-notifications` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to the 'Push Notifications' settings page to configure your Firebase credentials

## Firebase Setup

To use this plugin, you'll need to create a Firebase project:

1. Go to the [Firebase Console](https://console.firebase.google.com/)
2. Create a new project or select an existing one
3. Add a web app to your project
4. Copy the Firebase configuration values (apiKey, authDomain, projectId, etc.)
5. Go to Project Settings > Cloud Messaging and copy the Server Key
6. Enter these values in the plugin settings page

## Usage

### Adding a Subscription Button

You can add a subscription button to your site using the shortcode:

```
[quick_push_notifications_button]
```

### Sending Notifications

1. Go to Push Notifications > Compose in your WordPress admin
2. Enter a title and message for your notification
3. Optionally add a URL, icon, and image
4. Click "Send Notification" to send immediately or schedule for later

### Auto-Push for New Content

Enable auto-push in the plugin settings to automatically create notifications when new content is published.

## Frequently Asked Questions

### Is this compatible with all browsers?

Push notifications are supported in Chrome, Firefox, Edge, Opera, and Safari. Internet Explorer does not support push notifications.

### Do I need technical knowledge to set up Firebase?

Basic technical knowledge is helpful, but the plugin provides step-by-step instructions for setting up Firebase.

### Is there a limit to how many subscribers I can have?

No, there is no limit to the number of subscribers. However, Firebase may have its own limitations based on your Firebase plan.

### Is there a limit to how many notifications I can send?

No, there is no limit to the number of notifications you can send. However, Firebase may have its own limitations based on your Firebase plan.

## License

This plugin is licensed under the GPL v2 or later.

## Credits

This plugin was developed by Quick Plugins.
