<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://plugins.quickpr.co/
 * @since             1.0.0
 * @package           Quick_Image_Optimizer
 *
 * @wordpress-plugin
 * Plugin Name:       Quick Image Optimizer
 * Plugin URI:        https://plugins.quickpr.co/quick-image-optimizer
 * Description:       Automatically compress and optimize images on upload with WebP conversion, lazy loading, and CDN integration.
 * Version:           1.0.0
 * Author:            Quick LLC
 * Author URI:        https://plugins.quickpr.co/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       quick-image-optimizer
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 */
define('QUICK_IMAGE_OPTIMIZER_VERSION', '1.0.0');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-quick-image-optimizer-activator.php
 */
function activate_quick_image_optimizer() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-quick-image-optimizer-activator.php';
    Quick_Image_Optimizer_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-quick-image-optimizer-deactivator.php
 */
function deactivate_quick_image_optimizer() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-quick-image-optimizer-deactivator.php';
    Quick_Image_Optimizer_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_quick_image_optimizer');
register_deactivation_hook(__FILE__, 'deactivate_quick_image_optimizer');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-quick-image-optimizer.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_quick_image_optimizer() {
    $plugin = new Quick_Image_Optimizer();
    $plugin->run();
}
run_quick_image_optimizer();
