<?php
/**
 * Fired during plugin deactivation
 *
 * @link       https://plugins.quickpr.co/
 * @since      1.0.0
 *
 * @package    Quick_Image_Optimizer
 * @subpackage Quick_Image_Optimizer/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Quick_Image_Optimizer
 * @subpackage Quick_Image_Optimizer/includes
 * @author     Quick LLC <info@quickpr.co>
 */
class Quick_Image_Optimizer_Deactivator {

    /**
     * Clean up transients and temporary data on deactivation.
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        // Remove any transients
        delete_transient('qio_optimization_running');
        delete_transient('qio_bulk_optimization_status');
        delete_transient('qio_system_status');
        
        // We don't delete the options or optimization data on deactivation
        // This ensures that settings and optimization history are preserved if the plugin is reactivated
        
        // We also don't remove the backup directory or optimized images
        // This ensures that original images can be restored if needed
    }
}
