<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @link       https://plugins.quickpr.co/event-management
 * @since      1.0.0
 *
 * @package    Quick_Event_Management
 */

// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Access the database via SQL
global $wpdb;

// Delete custom post types and related data
$post_types = array('qem_event', 'qem_venue');

foreach ($post_types as $post_type) {
    $items = get_posts(
        array(
            'post_type'   => $post_type,
            'post_status' => 'any',
            'numberposts' => -1,
            'fields'      => 'ids',
        )
    );

    if ($items) {
        foreach ($items as $item) {
            wp_delete_post($item, true);
        }
    }
}

// Delete custom taxonomies and terms
$taxonomies = array('event_category', 'event_tag');

foreach ($taxonomies as $taxonomy) {
    $terms = get_terms(
        array(
            'taxonomy'   => $taxonomy,
            'hide_empty' => false,
        )
    );

    if (!empty($terms) && !is_wp_error($terms)) {
        foreach ($terms as $term) {
            wp_delete_term($term->term_id, $taxonomy);
        }
    }
}

// Drop custom database tables
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}qem_registrations");

// Delete plugin options
delete_option('qem_options');
delete_option('qem_db_version');

// Clear any cached data that has been cached by the plugin
wp_cache_flush();
