<?php
/**
 * Plugin Name: Quick Event Management
 * Plugin URI: https://plugins.quickpr.co/event-management
 * Description: A simple yet powerful event management system for WordPress with registration capabilities
 * Version: 1.0.0
 * Author: Quick LLC
 * Author URI: https://plugins.quickpr.co/
 * Text Domain: quick-event-management
 * Domain Path: /languages
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Currently plugin version.
 */
define('QUICK_EVENT_MANAGEMENT_VERSION', '1.0.0');
define('QUICK_EVENT_MANAGEMENT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('QUICK_EVENT_MANAGEMENT_PLUGIN_URL', plugin_dir_url(__FILE__));

/**
 * The code that runs during plugin activation.
 */
function activate_quick_event_management() {
    require_once QUICK_EVENT_MANAGEMENT_PLUGIN_DIR . 'includes/class-quick-event-management-activator.php';
    Quick_Event_Management_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_quick_event_management() {
    require_once QUICK_EVENT_MANAGEMENT_PLUGIN_DIR . 'includes/class-quick-event-management-deactivator.php';
    Quick_Event_Management_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_quick_event_management');
register_deactivation_hook(__FILE__, 'deactivate_quick_event_management');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require QUICK_EVENT_MANAGEMENT_PLUGIN_DIR . 'includes/class-quick-event-management.php';

/**
 * Begins execution of the plugin.
 */
function run_quick_event_management() {
    $plugin = new Quick_Event_Management();
    $plugin->run();
}

run_quick_event_management();
