<?php
/**
 * Template for displaying a single event
 *
 * @since      1.0.0
 */
?>

<div class="qem-single-event">
    <div class="qem-single-header">
        <h1 class="qem-single-title"><?php echo esc_html(get_the_title($event_id)); ?></h1>
        
        <div class="qem-single-meta">
            <?php if (!empty($start_date)) : ?>
                <div class="qem-event-date">
                    <i class="dashicons dashicons-calendar-alt"></i>
                    <?php 
                    if (!empty($end_date) && $start_date != $end_date) {
                        echo esc_html(date_i18n($date_format, strtotime($start_date))) . ' - ' . esc_html(date_i18n($date_format, strtotime($end_date)));
                    } else {
                        echo esc_html(date_i18n($date_format, strtotime($start_date)));
                    }
                    ?>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($start_time)) : ?>
                <div class="qem-event-time">
                    <i class="dashicons dashicons-clock"></i>
                    <?php 
                    if (!empty($end_time)) {
                        echo esc_html(date_i18n($time_format, strtotime($start_time))) . ' - ' . esc_html(date_i18n($time_format, strtotime($end_time)));
                    } else {
                        echo esc_html(date_i18n($time_format, strtotime($start_time)));
                    }
                    ?>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($venue_name)) : ?>
                <div class="qem-event-venue">
                    <i class="dashicons dashicons-location"></i>
                    <?php echo esc_html($venue_name); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <?php if (has_post_thumbnail($event_id)) : ?>
        <div class="qem-single-image">
            <?php echo get_the_post_thumbnail($event_id, 'large'); ?>
        </div>
    <?php endif; ?>
    
    <div class="qem-single-content">
        <?php echo apply_filters('the_content', get_post_field('post_content', $event_id)); ?>
    </div>
    
    <div class="qem-single-details">
        <h3><?php _e('Event Details', 'quick-event-management'); ?></h3>
        
        <div class="qem-detail-item">
            <span class="qem-detail-label"><?php _e('Date:', 'quick-event-management'); ?></span>
            <?php 
            if (!empty($start_date)) {
                if (!empty($end_date) && $start_date != $end_date) {
                    echo esc_html(date_i18n($date_format, strtotime($start_date))) . ' - ' . esc_html(date_i18n($date_format, strtotime($end_date)));
                } else {
                    echo esc_html(date_i18n($date_format, strtotime($start_date)));
                }
            } else {
                _e('TBD', 'quick-event-management');
            }
            ?>
        </div>
        
        <div class="qem-detail-item">
            <span class="qem-detail-label"><?php _e('Time:', 'quick-event-management'); ?></span>
            <?php 
            if (!empty($start_time)) {
                if (!empty($end_time)) {
                    echo esc_html(date_i18n($time_format, strtotime($start_time))) . ' - ' . esc_html(date_i18n($time_format, strtotime($end_time)));
                } else {
                    echo esc_html(date_i18n($time_format, strtotime($start_time)));
                }
            } else {
                _e('TBD', 'quick-event-management');
            }
            ?>
        </div>
        
        <?php if (!empty($venue_id)) : ?>
            <div class="qem-detail-item">
                <span class="qem-detail-label"><?php _e('Venue:', 'quick-event-management'); ?></span>
                <?php echo esc_html($venue_name); ?>
            </div>
            
            <?php
            $venue_address = get_post_meta($venue_id, 'qem_venue_address', true);
            $venue_city = get_post_meta($venue_id, 'qem_venue_city', true);
            $venue_state = get_post_meta($venue_id, 'qem_venue_state', true);
            $venue_zip = get_post_meta($venue_id, 'qem_venue_zip', true);
            $venue_country = get_post_meta($venue_id, 'qem_venue_country', true);
            
            $venue_full_address = array_filter(array($venue_address, $venue_city, $venue_state, $venue_zip, $venue_country));
            
            if (!empty($venue_full_address)) :
            ?>
                <div class="qem-venue-details">
                    <div class="qem-detail-item">
                        <span class="qem-detail-label"><?php _e('Address:', 'quick-event-management'); ?></span>
                        <?php echo esc_html(implode(', ', $venue_full_address)); ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
        
        <?php
        // Display event categories if available
        $event_categories = get_the_terms($event_id, 'event_category');
        if (!empty($event_categories) && !is_wp_error($event_categories)) :
        ?>
            <div class="qem-detail-item">
                <span class="qem-detail-label"><?php _e('Categories:', 'quick-event-management'); ?></span>
                <?php
                $category_names = array();
                foreach ($event_categories as $category) {
                    $category_names[] = '<a href="' . esc_url(get_term_link($category)) . '">' . esc_html($category->name) . '</a>';
                }
                echo implode(', ', $category_names);
                ?>
            </div>
        <?php endif; ?>
        
        <?php
        // Display event tags if available
        $event_tags = get_the_terms($event_id, 'event_tag');
        if (!empty($event_tags) && !is_wp_error($event_tags)) :
        ?>
            <div class="qem-detail-item">
                <span class="qem-detail-label"><?php _e('Tags:', 'quick-event-management'); ?></span>
                <?php
                $tag_names = array();
                foreach ($event_tags as $tag) {
                    $tag_names[] = '<a href="' . esc_url(get_term_link($tag)) . '">' . esc_html($tag->name) . '</a>';
                }
                echo implode(', ', $tag_names);
                ?>
            </div>
        <?php endif; ?>
        
        <?php if ($registration_enabled) : ?>
            <div class="qem-detail-item">
                <span class="qem-detail-label"><?php _e('Registration:', 'quick-event-management'); ?></span>
                <?php
                if ($is_event_full) {
                    echo '<span class="qem-registration-full">' . __('This event is full', 'quick-event-management') . '</span>';
                } elseif (!empty($registration_deadline) && strtotime($registration_deadline) < current_time('timestamp')) {
                    echo '<span class="qem-registration-closed">' . __('Registration closed', 'quick-event-management') . '</span>';
                } else {
                    echo '<span class="qem-registration-open">' . __('Registration open', 'quick-event-management') . '</span>';
                    
                    if (!empty($max_attendees)) {
                        echo ' <span class="qem-event-spaces" data-spaces="' . esc_attr($available_spaces) . '">';
                        printf(
                            _n('%s space available', '%s spaces available', $available_spaces, 'quick-event-management'),
                            $available_spaces
                        );
                        echo '</span>';
                    }
                }
                ?>
            </div>
        <?php endif; ?>
    </div>
    
    <?php if ($registration_enabled && !$is_event_full && (empty($registration_deadline) || strtotime($registration_deadline) >= current_time('timestamp'))) : ?>
        <?php include(plugin_dir_path(__FILE__) . 'quick-event-management-registration-form.php'); ?>
    <?php endif; ?>
</div>
