<?php
/**
 * Template for event registration form
 *
 * @since      1.0.0
 */
?>

<div class="qem-registration-form">
    <h3><?php _e('Register for this Event', 'quick-event-management'); ?></h3>
    
    <div class="qem-form-message" style="display: none;"></div>
    
    <form method="post">
        <div class="qem-form-row">
            <label for="qem_name"><?php _e('Name', 'quick-event-management'); ?> <?php echo in_array('name', $registration_fields) ? '*' : ''; ?></label>
            <input type="text" id="qem_name" name="qem_name" <?php echo in_array('name', $registration_fields) ? 'required' : ''; ?>>
        </div>
        
        <div class="qem-form-row">
            <label for="qem_email"><?php _e('Email', 'quick-event-management'); ?> <?php echo in_array('email', $registration_fields) ? '*' : ''; ?></label>
            <input type="email" id="qem_email" name="qem_email" <?php echo in_array('email', $registration_fields) ? 'required' : ''; ?>>
        </div>
        
        <?php if (in_array('phone', $registration_fields)) : ?>
            <div class="qem-form-row">
                <label for="qem_phone"><?php _e('Phone', 'quick-event-management'); ?> *</label>
                <input type="tel" id="qem_phone" name="qem_phone" required>
            </div>
        <?php endif; ?>
        
        <?php if (in_array('address', $registration_fields)) : ?>
            <div class="qem-form-row">
                <label for="qem_address"><?php _e('Address', 'quick-event-management'); ?> *</label>
                <input type="text" id="qem_address" name="qem_address" required>
            </div>
            
            <div class="qem-form-row" style="display: flex; gap: 15px;">
                <div style="flex: 1;">
                    <label for="qem_city"><?php _e('City', 'quick-event-management'); ?> *</label>
                    <input type="text" id="qem_city" name="qem_city" required>
                </div>
                
                <div style="flex: 1;">
                    <label for="qem_state"><?php _e('State/Province', 'quick-event-management'); ?> *</label>
                    <input type="text" id="qem_state" name="qem_state" required>
                </div>
            </div>
            
            <div class="qem-form-row" style="display: flex; gap: 15px;">
                <div style="flex: 1;">
                    <label for="qem_zip"><?php _e('ZIP/Postal Code', 'quick-event-management'); ?> *</label>
                    <input type="text" id="qem_zip" name="qem_zip" required>
                </div>
                
                <div style="flex: 1;">
                    <label for="qem_country"><?php _e('Country', 'quick-event-management'); ?> *</label>
                    <input type="text" id="qem_country" name="qem_country" required>
                </div>
            </div>
        <?php endif; ?>
        
        <?php if (in_array('company', $registration_fields)) : ?>
            <div class="qem-form-row">
                <label for="qem_company"><?php _e('Company', 'quick-event-management'); ?> *</label>
                <input type="text" id="qem_company" name="qem_company" required>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($max_attendees)) : ?>
            <div class="qem-form-row">
                <label for="qem_tickets"><?php _e('Number of Tickets', 'quick-event-management'); ?></label>
                <input type="number" id="qem_tickets" name="qem_tickets" value="1" min="1" max="<?php echo esc_attr($available_spaces); ?>" class="qem-ticket-quantity">
                <p class="description">
                    <?php printf(_n('Maximum %s ticket per registration', 'Maximum %s tickets per registration', $available_spaces, 'quick-event-management'), $available_spaces); ?>
                </p>
            </div>
        <?php endif; ?>
        
        <div class="qem-form-row">
            <label for="qem_notes"><?php _e('Notes or Questions', 'quick-event-management'); ?></label>
            <textarea id="qem_notes" name="qem_notes" rows="4"></textarea>
        </div>
        
        <?php if (!empty($options['enable_captcha']) && $options['enable_captcha'] == 1) : ?>
            <div class="qem-form-row">
                <label for="qem_captcha"><?php _e('Security Question', 'quick-event-management'); ?> *</label>
                <div class="qem-captcha">
                    <?php
                    $num1 = rand(1, 10);
                    $num2 = rand(1, 10);
                    ?>
                    <span class="qem-captcha-question"><?php printf(__('What is %s + %s?', 'quick-event-management'), $num1, $num2); ?></span>
                    <input type="number" id="qem_captcha" name="qem_captcha" required>
                    <input type="hidden" name="qem_captcha_num1" value="<?php echo esc_attr($num1); ?>">
                    <input type="hidden" name="qem_captcha_num2" value="<?php echo esc_attr($num2); ?>">
                </div>
            </div>
        <?php endif; ?>
        
        <input type="hidden" name="qem_event_id" value="<?php echo esc_attr($event_id); ?>">
        <input type="hidden" name="action" value="qem_register_event">
        <?php wp_nonce_field('qem_registration_nonce', 'qem_nonce'); ?>
        
        <div class="qem-form-submit">
            <button type="submit" class="qem-submit-button"><?php _e('Register', 'quick-event-management'); ?></button>
        </div>
    </form>
</div>
