<?php
/**
 * Template for displaying events list
 *
 * @since      1.0.0
 */
?>

<div class="qem-events-container">
    <?php if (!empty($events)) : ?>
        <?php if (!empty($atts['filter']) && $atts['filter'] == 'true') : ?>
            <div class="qem-event-filter">
                <form method="get">
                    <?php if (!empty($categories)) : ?>
                        <select name="qem_category" onchange="this.form.submit()">
                            <option value=""><?php _e('All Categories', 'quick-event-management'); ?></option>
                            <?php foreach ($categories as $category) : ?>
                                <option value="<?php echo esc_attr($category->slug); ?>" <?php selected(isset($_GET['qem_category']) ? $_GET['qem_category'] : '', $category->slug); ?>>
                                    <?php echo esc_html($category->name); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    <?php endif; ?>
                    
                    <select name="qem_time" onchange="this.form.submit()">
                        <option value="upcoming" <?php selected(isset($_GET['qem_time']) ? $_GET['qem_time'] : 'upcoming', 'upcoming'); ?>>
                            <?php _e('Upcoming Events', 'quick-event-management'); ?>
                        </option>
                        <option value="past" <?php selected(isset($_GET['qem_time']) ? $_GET['qem_time'] : '', 'past'); ?>>
                            <?php _e('Past Events', 'quick-event-management'); ?>
                        </option>
                        <option value="all" <?php selected(isset($_GET['qem_time']) ? $_GET['qem_time'] : '', 'all'); ?>>
                            <?php _e('All Events', 'quick-event-management'); ?>
                        </option>
                    </select>
                </form>
            </div>
        <?php endif; ?>
        
        <?php if ($atts['view'] == 'grid') : ?>
            <div class="qem-events-grid" style="grid-template-columns: repeat(<?php echo esc_attr($atts['columns']); ?>, 1fr);">
                <?php foreach ($events as $event) : ?>
                    <?php
                    $event_id = $event->ID;
                    $event_title = get_the_title($event_id);
                    $event_link = get_permalink($event_id);
                    $event_date = get_post_meta($event_id, 'qem_event_start_date', true);
                    $event_time = get_post_meta($event_id, 'qem_event_start_time', true);
                    $venue_id = get_post_meta($event_id, 'qem_event_venue', true);
                    $venue_name = !empty($venue_id) ? get_the_title($venue_id) : '';
                    $thumbnail = has_post_thumbnail($event_id) ? get_the_post_thumbnail_url($event_id, 'medium') : '';
                    ?>
                    
                    <div class="qem-grid-item">
                        <?php if (!empty($thumbnail)) : ?>
                            <div class="qem-grid-image">
                                <a href="<?php echo esc_url($event_link); ?>">
                                    <img src="<?php echo esc_url($thumbnail); ?>" alt="<?php echo esc_attr($event_title); ?>">
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <div class="qem-grid-content">
                            <h3 class="qem-grid-title">
                                <a href="<?php echo esc_url($event_link); ?>"><?php echo esc_html($event_title); ?></a>
                            </h3>
                            
                            <div class="qem-grid-meta">
                                <?php if (!empty($event_date)) : ?>
                                    <div class="qem-event-date">
                                        <i class="dashicons dashicons-calendar-alt"></i>
                                        <?php echo esc_html(date_i18n($date_format, strtotime($event_date))); ?>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($event_time)) : ?>
                                    <div class="qem-event-time">
                                        <i class="dashicons dashicons-clock"></i>
                                        <?php echo esc_html(date_i18n($time_format, strtotime($event_time))); ?>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($venue_name)) : ?>
                                    <div class="qem-event-venue">
                                        <i class="dashicons dashicons-location"></i>
                                        <?php echo esc_html($venue_name); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <?php if (!empty($atts['excerpt']) && $atts['excerpt'] == 'true') : ?>
                                <div class="qem-grid-excerpt">
                                    <?php echo wp_trim_words(get_the_excerpt($event_id), 15); ?>
                                </div>
                            <?php endif; ?>
                            
                            <div class="qem-grid-footer">
                                <a href="<?php echo esc_url($event_link); ?>" class="qem-event-button">
                                    <?php _e('View Details', 'quick-event-management'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else : ?>
            <div class="qem-events-list">
                <?php foreach ($events as $event) : ?>
                    <?php
                    $event_id = $event->ID;
                    $event_title = get_the_title($event_id);
                    $event_link = get_permalink($event_id);
                    $event_date = get_post_meta($event_id, 'qem_event_start_date', true);
                    $event_time = get_post_meta($event_id, 'qem_event_start_time', true);
                    $venue_id = get_post_meta($event_id, 'qem_event_venue', true);
                    $venue_name = !empty($venue_id) ? get_the_title($venue_id) : '';
                    $thumbnail = has_post_thumbnail($event_id) ? get_the_post_thumbnail_url($event_id, 'medium') : '';
                    ?>
                    
                    <div class="qem-event-item">
                        <div class="qem-event-header">
                            <h2 class="qem-event-title">
                                <a href="<?php echo esc_url($event_link); ?>"><?php echo esc_html($event_title); ?></a>
                            </h2>
                        </div>
                        
                        <div class="qem-event-meta">
                            <?php if (!empty($event_date)) : ?>
                                <div class="qem-event-date">
                                    <i class="dashicons dashicons-calendar-alt"></i>
                                    <?php echo esc_html(date_i18n($date_format, strtotime($event_date))); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($event_time)) : ?>
                                <div class="qem-event-time">
                                    <i class="dashicons dashicons-clock"></i>
                                    <?php echo esc_html(date_i18n($time_format, strtotime($event_time))); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($venue_name)) : ?>
                                <div class="qem-event-venue">
                                    <i class="dashicons dashicons-location"></i>
                                    <?php echo esc_html($venue_name); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <?php if (!empty($thumbnail)) : ?>
                            <div class="qem-event-image">
                                <a href="<?php echo esc_url($event_link); ?>">
                                    <img src="<?php echo esc_url($thumbnail); ?>" alt="<?php echo esc_attr($event_title); ?>">
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($atts['excerpt']) && $atts['excerpt'] == 'true') : ?>
                            <div class="qem-event-excerpt">
                                <?php echo wp_trim_words(get_the_excerpt($event_id), 30); ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="qem-event-footer">
                            <a href="<?php echo esc_url($event_link); ?>" class="qem-event-button">
                                <?php _e('View Details', 'quick-event-management'); ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($pagination && $total_pages > 1) : ?>
            <div class="qem-pagination">
                <?php
                echo paginate_links(array(
                    'base' => add_query_arg('qem_page', '%#%'),
                    'format' => '',
                    'prev_text' => __('&laquo; Previous', 'quick-event-management'),
                    'next_text' => __('Next &raquo;', 'quick-event-management'),
                    'total' => $total_pages,
                    'current' => $current_page,
                ));
                ?>
            </div>
        <?php endif; ?>
    <?php else : ?>
        <p><?php _e('No events found.', 'quick-event-management'); ?></p>
    <?php endif; ?>
</div>
