<?php
/**
 * Template for displaying events calendar
 *
 * @since      1.0.0
 */
?>

<div class="qem-calendar" data-category="<?php echo esc_attr($atts['category']); ?>" data-tag="<?php echo esc_attr($atts['tag']); ?>">
    <div class="qem-calendar-header">
        <div class="qem-calendar-title">
            <?php echo esc_html($month_name . ' ' . $year); ?>
        </div>
        <div class="qem-calendar-nav">
            <a href="#" class="qem-calendar-prev" data-month="<?php echo esc_attr($prev_month); ?>" data-year="<?php echo esc_attr($prev_year); ?>">
                &laquo; <?php _e('Previous', 'quick-event-management'); ?>
            </a>
            <a href="#" class="qem-calendar-next" data-month="<?php echo esc_attr($next_month); ?>" data-year="<?php echo esc_attr($next_year); ?>">
                <?php _e('Next', 'quick-event-management'); ?> &raquo;
            </a>
        </div>
    </div>
    
    <table class="qem-calendar-table">
        <thead>
            <tr>
                <?php
                $start_of_week = get_option('start_of_week', 0);
                $days = array(
                    __('Sunday', 'quick-event-management'),
                    __('Monday', 'quick-event-management'),
                    __('Tuesday', 'quick-event-management'),
                    __('Wednesday', 'quick-event-management'),
                    __('Thursday', 'quick-event-management'),
                    __('Friday', 'quick-event-management'),
                    __('Saturday', 'quick-event-management')
                );
                
                // Reorder days based on start of week
                if ($start_of_week > 0) {
                    $days_slice = array_slice($days, $start_of_week);
                    $days = array_merge($days_slice, array_slice($days, 0, $start_of_week));
                }
                
                foreach ($days as $day) {
                    echo '<th>' . esc_html(substr($day, 0, 3)) . '</th>';
                }
                ?>
            </tr>
        </thead>
        <tbody>
            <?php
            // Get the first day of the month
            $first_day_timestamp = mktime(0, 0, 0, $month, 1, $year);
            $first_day_of_week = date('w', $first_day_timestamp);
            
            // Adjust for start of week
            $first_day_of_week = ($first_day_of_week - $start_of_week + 7) % 7;
            
            // Get the number of days in the month
            $days_in_month = date('t', $first_day_timestamp);
            
            // Calculate the number of weeks to display
            $weeks = ceil(($days_in_month + $first_day_of_week) / 7);
            
            // Start building the calendar
            $day_counter = 1 - $first_day_of_week;
            
            for ($week = 0; $week < $weeks; $week++) {
                echo '<tr>';
                
                for ($weekday = 0; $weekday < 7; $weekday++) {
                    if ($day_counter <= 0 || $day_counter > $days_in_month) {
                        // Day is outside the current month
                        echo '<td class="qem-calendar-day qem-other-month"></td>';
                    } else {
                        // Day is within the current month
                        $date = sprintf('%04d-%02d-%02d', $year, $month, $day_counter);
                        $day_events = isset($events_by_date[$date]) ? $events_by_date[$date] : array();
                        
                        echo '<td class="qem-calendar-day">';
                        echo '<div class="qem-calendar-day-number">' . esc_html($day_counter) . '</div>';
                        
                        // Display events for this day
                        if (!empty($day_events)) {
                            foreach ($day_events as $event) {
                                echo '<div class="qem-calendar-event">';
                                echo '<a href="' . esc_url(get_permalink($event->ID)) . '" title="' . esc_attr(get_the_title($event->ID)) . '">';
                                echo esc_html(get_the_title($event->ID));
                                echo '</a>';
                                echo '</div>';
                            }
                        }
                        
                        echo '</td>';
                    }
                    
                    $day_counter++;
                }
                
                echo '</tr>';
            }
            ?>
        </tbody>
    </table>
</div>
