(function( $ ) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 */

	$(document).ready(function() {
		// Handle registration form submission
		$('.qem-registration-form form').on('submit', function(e) {
			e.preventDefault();
			
			var $form = $(this);
			var $submitButton = $form.find('button[type="submit"]');
			var $message = $form.find('.qem-form-message');
			
			// Clear previous messages
			$message.removeClass('success error').empty().hide();
			
			// Disable submit button
			$submitButton.prop('disabled', true).text('Submitting...');
			
			// Get form data
			var formData = $form.serialize();
			
			// Send AJAX request
			$.ajax({
				url: qem_ajax.ajax_url,
				type: 'POST',
				data: formData + '&action=qem_register_event&nonce=' + qem_ajax.nonce,
				success: function(response) {
					if (response.success) {
						// Show success message
						$message.addClass('success').html(response.data.message).show();
						
						// Reset form
						$form[0].reset();
						
						// Scroll to message
						$('html, body').animate({
							scrollTop: $message.offset().top - 100
						}, 500);
						
						// Update available spaces if applicable
						var $spacesElement = $('.qem-event-spaces');
						if ($spacesElement.length) {
							var currentSpaces = parseInt($spacesElement.data('spaces'));
							var ticketsBooked = parseInt($form.find('input[name="tickets"]').val() || 1);
							var newSpaces = currentSpaces - ticketsBooked;
							
							if (newSpaces <= 0) {
								$('.qem-registration-form').html('<p>This event is now full.</p>');
							} else {
								$spacesElement.text(newSpaces).data('spaces', newSpaces);
							}
						}
					} else {
						// Show error message
						$message.addClass('error').html(response.data.message).show();
					}
					
					// Re-enable submit button
					$submitButton.prop('disabled', false).text('Register');
				},
				error: function() {
					// Show error message
					$message.addClass('error').html('An error occurred. Please try again.').show();
					
					// Re-enable submit button
					$submitButton.prop('disabled', false).text('Register');
				}
			});
		});

		// Calendar navigation
		$('.qem-calendar-nav a').on('click', function(e) {
			e.preventDefault();
			
			var $this = $(this);
			var $calendar = $this.closest('.qem-calendar');
			var month = $this.data('month');
			var year = $this.data('year');
			var category = $calendar.data('category') || '';
			var tag = $calendar.data('tag') || '';
			
			$.ajax({
				url: qem_ajax.ajax_url,
				type: 'POST',
				data: {
					action: 'qem_load_calendar',
					month: month,
					year: year,
					category: category,
					tag: tag,
					nonce: qem_ajax.nonce
				},
				success: function(response) {
					if (response.success) {
						$calendar.html(response.data.html);
					}
				}
			});
		});

		// Ticket quantity input
		$('.qem-ticket-quantity').on('change', function() {
			var $this = $(this);
			var maxTickets = parseInt($this.attr('max'));
			var value = parseInt($this.val());
			
			// Ensure value is within range
			if (isNaN(value) || value < 1) {
				$this.val(1);
			} else if (maxTickets && value > maxTickets) {
				$this.val(maxTickets);
			}
		});

		// Initialize tooltips
		if ($.fn.tooltip) {
			$('.qem-tooltip').tooltip();
		}

		// Event filtering
		$('.qem-event-filter select').on('change', function() {
			var $form = $(this).closest('form');
			$form.submit();
		});
	});

})( jQuery );
