<?php

/**
 * Register custom post types and taxonomies for the plugin.
 *
 * @since      1.0.0
 */
class Quick_Event_Management_Post_Types {

    /**
     * Register custom post types.
     *
     * @since    1.0.0
     */
    public function register_post_types() {
        // Get settings
        $settings = get_option('qem_settings', array());
        $event_slug = !empty($settings['event_slug']) ? $settings['event_slug'] : 'event';
        
        // Register Event post type
        $labels = array(
            'name'                  => _x('Events', 'Post type general name', 'quick-event-management'),
            'singular_name'         => _x('Event', 'Post type singular name', 'quick-event-management'),
            'menu_name'             => _x('Events', 'Admin Menu text', 'quick-event-management'),
            'name_admin_bar'        => _x('Event', 'Add New on Toolbar', 'quick-event-management'),
            'add_new'               => __('Add New', 'quick-event-management'),
            'add_new_item'          => __('Add New Event', 'quick-event-management'),
            'new_item'              => __('New Event', 'quick-event-management'),
            'edit_item'             => __('Edit Event', 'quick-event-management'),
            'view_item'             => __('View Event', 'quick-event-management'),
            'all_items'             => __('All Events', 'quick-event-management'),
            'search_items'          => __('Search Events', 'quick-event-management'),
            'parent_item_colon'     => __('Parent Events:', 'quick-event-management'),
            'not_found'             => __('No events found.', 'quick-event-management'),
            'not_found_in_trash'    => __('No events found in Trash.', 'quick-event-management'),
            'featured_image'        => _x('Event Cover Image', 'Overrides the "Featured Image" phrase', 'quick-event-management'),
            'set_featured_image'    => _x('Set cover image', 'Overrides the "Set featured image" phrase', 'quick-event-management'),
            'remove_featured_image' => _x('Remove cover image', 'Overrides the "Remove featured image" phrase', 'quick-event-management'),
            'use_featured_image'    => _x('Use as cover image', 'Overrides the "Use as featured image" phrase', 'quick-event-management'),
            'archives'              => _x('Event archives', 'The post type archive label used in nav menus', 'quick-event-management'),
            'insert_into_item'      => _x('Insert into event', 'Overrides the "Insert into post" phrase', 'quick-event-management'),
            'uploaded_to_this_item' => _x('Uploaded to this event', 'Overrides the "Uploaded to this post" phrase', 'quick-event-management'),
            'filter_items_list'     => _x('Filter events list', 'Screen reader text for the filter links', 'quick-event-management'),
            'items_list_navigation' => _x('Events list navigation', 'Screen reader text for the pagination', 'quick-event-management'),
            'items_list'            => _x('Events list', 'Screen reader text for the items list', 'quick-event-management'),
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => array('slug' => $event_slug),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => 20,
            'menu_icon'          => 'dashicons-calendar-alt',
            'supports'           => array('title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments'),
            'show_in_rest'       => true,
        );

        register_post_type('qem_event', $args);
        
        // Register Venue post type
        $labels = array(
            'name'                  => _x('Venues', 'Post type general name', 'quick-event-management'),
            'singular_name'         => _x('Venue', 'Post type singular name', 'quick-event-management'),
            'menu_name'             => _x('Venues', 'Admin Menu text', 'quick-event-management'),
            'name_admin_bar'        => _x('Venue', 'Add New on Toolbar', 'quick-event-management'),
            'add_new'               => __('Add New', 'quick-event-management'),
            'add_new_item'          => __('Add New Venue', 'quick-event-management'),
            'new_item'              => __('New Venue', 'quick-event-management'),
            'edit_item'             => __('Edit Venue', 'quick-event-management'),
            'view_item'             => __('View Venue', 'quick-event-management'),
            'all_items'             => __('All Venues', 'quick-event-management'),
            'search_items'          => __('Search Venues', 'quick-event-management'),
            'parent_item_colon'     => __('Parent Venues:', 'quick-event-management'),
            'not_found'             => __('No venues found.', 'quick-event-management'),
            'not_found_in_trash'    => __('No venues found in Trash.', 'quick-event-management'),
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => 'edit.php?post_type=qem_event',
            'query_var'          => true,
            'rewrite'            => array('slug' => 'venue'),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'supports'           => array('title', 'editor', 'thumbnail'),
            'show_in_rest'       => true,
        );

        register_post_type('qem_venue', $args);
    }

    /**
     * Register custom taxonomies.
     *
     * @since    1.0.0
     */
    public function register_taxonomies() {
        // Event Category Taxonomy
        $labels = array(
            'name'              => _x('Event Categories', 'taxonomy general name', 'quick-event-management'),
            'singular_name'     => _x('Event Category', 'taxonomy singular name', 'quick-event-management'),
            'search_items'      => __('Search Event Categories', 'quick-event-management'),
            'all_items'         => __('All Event Categories', 'quick-event-management'),
            'parent_item'       => __('Parent Event Category', 'quick-event-management'),
            'parent_item_colon' => __('Parent Event Category:', 'quick-event-management'),
            'edit_item'         => __('Edit Event Category', 'quick-event-management'),
            'update_item'       => __('Update Event Category', 'quick-event-management'),
            'add_new_item'      => __('Add New Event Category', 'quick-event-management'),
            'new_item_name'     => __('New Event Category Name', 'quick-event-management'),
            'menu_name'         => __('Categories', 'quick-event-management'),
        );

        $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array('slug' => 'event-category'),
            'show_in_rest'      => true,
        );

        register_taxonomy('qem_event_category', array('qem_event'), $args);

        // Event Tags Taxonomy
        $labels = array(
            'name'              => _x('Event Tags', 'taxonomy general name', 'quick-event-management'),
            'singular_name'     => _x('Event Tag', 'taxonomy singular name', 'quick-event-management'),
            'search_items'      => __('Search Event Tags', 'quick-event-management'),
            'all_items'         => __('All Event Tags', 'quick-event-management'),
            'parent_item'       => __('Parent Event Tag', 'quick-event-management'),
            'parent_item_colon' => __('Parent Event Tag:', 'quick-event-management'),
            'edit_item'         => __('Edit Event Tag', 'quick-event-management'),
            'update_item'       => __('Update Event Tag', 'quick-event-management'),
            'add_new_item'      => __('Add New Event Tag', 'quick-event-management'),
            'new_item_name'     => __('New Event Tag Name', 'quick-event-management'),
            'menu_name'         => __('Tags', 'quick-event-management'),
        );

        $args = array(
            'hierarchical'      => false,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array('slug' => 'event-tag'),
            'show_in_rest'      => true,
        );

        register_taxonomy('qem_event_tag', array('qem_event'), $args);
    }
}
