<?php

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 */
class Quick_Event_Management_Deactivator {

    /**
     * Clean up when plugin is deactivated.
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        // Flush rewrite rules
        flush_rewrite_rules();
        
        // We don't delete tables or options here to preserve user data
        // Tables and options will only be removed if the user chooses to delete data upon uninstall
    }
}
