<?php

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 */
class Quick_Event_Management_Activator {

    /**
     * Create necessary database tables and set up initial plugin settings.
     *
     * @since    1.0.0
     */
    public static function activate() {
        global $wpdb;
        
        // Create registrations table
        $table_name = $wpdb->prefix . 'qem_registrations';
        $charset_collate = $wpdb->get_charset_collate();
        
        $sql = "CREATE TABLE $table_name (
            id mediumint(9) NOT NULL AUTO_INCREMENT,
            event_id mediumint(9) NOT NULL,
            name varchar(100) NOT NULL,
            email varchar(100) NOT NULL,
            phone varchar(20),
            tickets smallint(5) NOT NULL DEFAULT 1,
            status varchar(20) NOT NULL DEFAULT 'confirmed',
            registration_date datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
            notes text,
            PRIMARY KEY  (id)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
        
        // Add version to options
        add_option('qem_db_version', QUICK_EVENT_MANAGEMENT_VERSION);
        
        // Set default options
        $default_options = array(
            'event_slug' => 'event',
            'events_per_page' => 10,
            'date_format' => 'F j, Y',
            'time_format' => 'g:i a',
            'require_approval' => false,
            'notify_admin' => true,
            'notify_registrant' => true,
            'admin_email_subject' => 'New Event Registration',
            'registrant_email_subject' => 'Your Event Registration Confirmation'
        );
        
        add_option('qem_settings', $default_options);
        
        // Flush rewrite rules to add our custom post types
        flush_rewrite_rules();
    }
}
