<?php
/**
 * Template for plugin settings page
 *
 * @since      1.0.0
 */
?>

<div class="wrap qem-admin-container">
    <div class="qem-admin-header">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    </div>
    
    <div class="qem-admin-content">
        <form method="post" action="options.php">
            <?php
            settings_fields('quick_event_management_settings');
            do_settings_sections('quick_event_management_settings');
            ?>
            
            <div class="qem-settings-section">
                <h2><?php _e('General Settings', 'quick-event-management'); ?></h2>
                
                <div class="qem-form-row">
                    <label for="qem_event_slug"><?php _e('Event Slug', 'quick-event-management'); ?></label>
                    <input type="text" id="qem_event_slug" name="qem_options[event_slug]" value="<?php echo esc_attr($options['event_slug']); ?>">
                    <p class="description"><?php _e('The slug used for event URLs. After changing this, go to Settings > Permalinks and click Save to update your permalink structure.', 'quick-event-management'); ?></p>
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_venue_slug"><?php _e('Venue Slug', 'quick-event-management'); ?></label>
                    <input type="text" id="qem_venue_slug" name="qem_options[venue_slug]" value="<?php echo esc_attr($options['venue_slug']); ?>">
                    <p class="description"><?php _e('The slug used for venue URLs. After changing this, go to Settings > Permalinks and click Save to update your permalink structure.', 'quick-event-management'); ?></p>
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_events_per_page"><?php _e('Events Per Page', 'quick-event-management'); ?></label>
                    <input type="number" id="qem_events_per_page" name="qem_options[events_per_page]" value="<?php echo esc_attr($options['events_per_page']); ?>" min="1">
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_date_format"><?php _e('Date Format', 'quick-event-management'); ?></label>
                    <select id="qem_date_format" name="qem_options[date_format]">
                        <option value="F j, Y" <?php selected($options['date_format'], 'F j, Y'); ?>><?php echo date_i18n('F j, Y'); ?> (F j, Y)</option>
                        <option value="Y-m-d" <?php selected($options['date_format'], 'Y-m-d'); ?>><?php echo date_i18n('Y-m-d'); ?> (Y-m-d)</option>
                        <option value="m/d/Y" <?php selected($options['date_format'], 'm/d/Y'); ?>><?php echo date_i18n('m/d/Y'); ?> (m/d/Y)</option>
                        <option value="d/m/Y" <?php selected($options['date_format'], 'd/m/Y'); ?>><?php echo date_i18n('d/m/Y'); ?> (d/m/Y)</option>
                    </select>
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_time_format"><?php _e('Time Format', 'quick-event-management'); ?></label>
                    <select id="qem_time_format" name="qem_options[time_format]">
                        <option value="g:i a" <?php selected($options['time_format'], 'g:i a'); ?>><?php echo date_i18n('g:i a'); ?> (g:i a)</option>
                        <option value="g:i A" <?php selected($options['time_format'], 'g:i A'); ?>><?php echo date_i18n('g:i A'); ?> (g:i A)</option>
                        <option value="H:i" <?php selected($options['time_format'], 'H:i'); ?>><?php echo date_i18n('H:i'); ?> (H:i)</option>
                    </select>
                </div>
            </div>
            
            <div class="qem-settings-section">
                <h2><?php _e('Registration Settings', 'quick-event-management'); ?></h2>
                
                <div class="qem-form-row">
                    <label for="qem_default_registration_status"><?php _e('Default Registration Status', 'quick-event-management'); ?></label>
                    <select id="qem_default_registration_status" name="qem_options[default_registration_status]">
                        <option value="confirmed" <?php selected($options['default_registration_status'], 'confirmed'); ?>><?php _e('Confirmed', 'quick-event-management'); ?></option>
                        <option value="pending" <?php selected($options['default_registration_status'], 'pending'); ?>><?php _e('Pending', 'quick-event-management'); ?></option>
                    </select>
                    <p class="description"><?php _e('The default status for new registrations. This can be overridden on a per-event basis.', 'quick-event-management'); ?></p>
                </div>
                
                <div class="qem-form-row">
                    <label>
                        <input type="checkbox" name="qem_options[enable_captcha]" value="1" <?php checked($options['enable_captcha'], 1); ?>>
                        <?php _e('Enable CAPTCHA on Registration Forms', 'quick-event-management'); ?>
                    </label>
                </div>
            </div>
            
            <div class="qem-settings-section">
                <h2><?php _e('Email Settings', 'quick-event-management'); ?></h2>
                
                <div class="qem-form-row">
                    <label for="qem_from_email"><?php _e('From Email', 'quick-event-management'); ?></label>
                    <input type="email" id="qem_from_email" name="qem_options[from_email]" value="<?php echo esc_attr($options['from_email']); ?>">
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_from_name"><?php _e('From Name', 'quick-event-management'); ?></label>
                    <input type="text" id="qem_from_name" name="qem_options[from_name]" value="<?php echo esc_attr($options['from_name']); ?>">
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_admin_notification_email"><?php _e('Admin Notification Email', 'quick-event-management'); ?></label>
                    <input type="email" id="qem_admin_notification_email" name="qem_options[admin_notification_email]" value="<?php echo esc_attr($options['admin_notification_email']); ?>">
                    <p class="description"><?php _e('Email address to receive registration notifications. Leave blank to use the admin email.', 'quick-event-management'); ?></p>
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_confirmation_subject"><?php _e('Confirmation Email Subject', 'quick-event-management'); ?></label>
                    <input type="text" id="qem_confirmation_subject" name="qem_options[confirmation_subject]" value="<?php echo esc_attr($options['confirmation_subject']); ?>">
                    <p class="description"><?php _e('Available placeholders: {event_title}, {event_date}, {site_name}', 'quick-event-management'); ?></p>
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_confirmation_message"><?php _e('Default Confirmation Email Message', 'quick-event-management'); ?></label>
                    <textarea id="qem_confirmation_message" name="qem_options[confirmation_message]" rows="5"><?php echo esc_textarea($options['confirmation_message']); ?></textarea>
                    <p class="description"><?php _e('Available placeholders: {name}, {event_title}, {event_date}, {event_time}, {venue}, {registration_details}, {site_name}', 'quick-event-management'); ?></p>
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_notification_subject"><?php _e('Admin Notification Email Subject', 'quick-event-management'); ?></label>
                    <input type="text" id="qem_notification_subject" name="qem_options[notification_subject]" value="<?php echo esc_attr($options['notification_subject']); ?>">
                </div>
            </div>
            
            <div class="qem-settings-section">
                <h2><?php _e('Display Settings', 'quick-event-management'); ?></h2>
                
                <div class="qem-form-row">
                    <label for="qem_default_view"><?php _e('Default Events View', 'quick-event-management'); ?></label>
                    <select id="qem_default_view" name="qem_options[default_view]">
                        <option value="list" <?php selected($options['default_view'], 'list'); ?>><?php _e('List', 'quick-event-management'); ?></option>
                        <option value="grid" <?php selected($options['default_view'], 'grid'); ?>><?php _e('Grid', 'quick-event-management'); ?></option>
                        <option value="calendar" <?php selected($options['default_view'], 'calendar'); ?>><?php _e('Calendar', 'quick-event-management'); ?></option>
                    </select>
                </div>
                
                <div class="qem-form-row">
                    <label for="qem_grid_columns"><?php _e('Grid Columns', 'quick-event-management'); ?></label>
                    <select id="qem_grid_columns" name="qem_options[grid_columns]">
                        <option value="2" <?php selected($options['grid_columns'], '2'); ?>>2</option>
                        <option value="3" <?php selected($options['grid_columns'], '3'); ?>>3</option>
                        <option value="4" <?php selected($options['grid_columns'], '4'); ?>>4</option>
                    </select>
                </div>
                
                <div class="qem-form-row">
                    <label>
                        <input type="checkbox" name="qem_options[show_past_events]" value="1" <?php checked($options['show_past_events'], 1); ?>>
                        <?php _e('Show Past Events', 'quick-event-management'); ?>
                    </label>
                </div>
            </div>
            
            <?php submit_button(); ?>
        </form>
    </div>
</div>
