<?php
/**
 * Template for event registrations list metabox
 *
 * @since      1.0.0
 */
?>

<?php if (empty($registrations)) : ?>
    <p><?php _e('No registrations found for this event.', 'quick-event-management'); ?></p>
<?php else : ?>
    <div class="qem-registrations-header" style="margin-bottom: 15px;">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <strong><?php printf(_n('%s Registration', '%s Registrations', count($registrations), 'quick-event-management'), count($registrations)); ?></strong>
                <?php if (!empty($max_attendees)) : ?>
                    <span class="description"><?php printf(__('(Maximum: %s)', 'quick-event-management'), $max_attendees); ?></span>
                <?php endif; ?>
            </div>
            <div>
                <a href="#" id="qem-export-registrations" class="button" data-event-id="<?php echo esc_attr($post->ID); ?>" data-nonce="<?php echo esc_attr(wp_create_nonce('qem_export_registrations')); ?>">
                    <?php _e('Export to CSV', 'quick-event-management'); ?>
                </a>
            </div>
        </div>
    </div>

    <table class="qem-registrations-table">
        <thead>
            <tr>
                <th><?php _e('Name', 'quick-event-management'); ?></th>
                <th><?php _e('Email', 'quick-event-management'); ?></th>
                <th><?php _e('Phone', 'quick-event-management'); ?></th>
                <th><?php _e('Tickets', 'quick-event-management'); ?></th>
                <th><?php _e('Registration Date', 'quick-event-management'); ?></th>
                <th><?php _e('Status', 'quick-event-management'); ?></th>
                <th><?php _e('Actions', 'quick-event-management'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($registrations as $registration) : ?>
                <tr>
                    <td><?php echo esc_html($registration->name); ?></td>
                    <td>
                        <a href="mailto:<?php echo esc_attr($registration->email); ?>">
                            <?php echo esc_html($registration->email); ?>
                        </a>
                    </td>
                    <td><?php echo esc_html($registration->phone); ?></td>
                    <td><?php echo esc_html($registration->tickets); ?></td>
                    <td>
                        <?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($registration->registration_date)); ?>
                    </td>
                    <td>
                        <?php
                        $status_class = '';
                        switch ($registration->status) {
                            case 'confirmed':
                                $status_class = 'qem-status-confirmed';
                                break;
                            case 'pending':
                                $status_class = 'qem-status-pending';
                                break;
                            case 'cancelled':
                                $status_class = 'qem-status-cancelled';
                                break;
                        }
                        ?>
                        <span class="<?php echo esc_attr($status_class); ?>">
                            <?php echo esc_html(ucfirst($registration->status)); ?>
                        </span>
                    </td>
                    <td class="qem-registrations-actions">
                        <?php if ($registration->status !== 'confirmed') : ?>
                            <a href="#" class="qem-change-status button button-small" 
                               data-id="<?php echo esc_attr($registration->id); ?>" 
                               data-status="confirmed" 
                               data-nonce="<?php echo esc_attr(wp_create_nonce('qem_change_registration_status')); ?>"
                               title="<?php esc_attr_e('Confirm', 'quick-event-management'); ?>">
                                <span class="dashicons dashicons-yes"></span>
                            </a>
                        <?php endif; ?>
                        
                        <?php if ($registration->status !== 'pending') : ?>
                            <a href="#" class="qem-change-status button button-small" 
                               data-id="<?php echo esc_attr($registration->id); ?>" 
                               data-status="pending" 
                               data-nonce="<?php echo esc_attr(wp_create_nonce('qem_change_registration_status')); ?>"
                               title="<?php esc_attr_e('Mark as Pending', 'quick-event-management'); ?>">
                                <span class="dashicons dashicons-clock"></span>
                            </a>
                        <?php endif; ?>
                        
                        <?php if ($registration->status !== 'cancelled') : ?>
                            <a href="#" class="qem-change-status button button-small" 
                               data-id="<?php echo esc_attr($registration->id); ?>" 
                               data-status="cancelled" 
                               data-nonce="<?php echo esc_attr(wp_create_nonce('qem_change_registration_status')); ?>"
                               title="<?php esc_attr_e('Cancel', 'quick-event-management'); ?>">
                                <span class="dashicons dashicons-no"></span>
                            </a>
                        <?php endif; ?>
                        
                        <a href="#" class="qem-delete-registration button button-small" 
                           data-id="<?php echo esc_attr($registration->id); ?>" 
                           data-nonce="<?php echo esc_attr(wp_create_nonce('qem_delete_registration')); ?>"
                           title="<?php esc_attr_e('Delete', 'quick-event-management'); ?>">
                            <span class="dashicons dashicons-trash"></span>
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
