<?php
/**
 * Template for event registration settings metabox
 *
 * @since      1.0.0
 */
?>

<div class="qem-meta-field">
    <label for="qem_event_registration_enabled">
        <input type="checkbox" id="qem_event_registration_enabled" name="qem_event_registration_enabled" value="1" <?php checked($registration_enabled, 1); ?>>
        <?php _e('Enable Registration for this Event', 'quick-event-management'); ?>
    </label>
</div>

<div class="qem-registration-settings" style="margin-top: 15px;">
    <div class="qem-meta-field">
        <label for="qem_event_max_attendees"><?php _e('Maximum Attendees', 'quick-event-management'); ?></label>
        <input type="number" id="qem_event_max_attendees" name="qem_event_max_attendees" value="<?php echo esc_attr($max_attendees); ?>" min="0">
        <p class="description"><?php _e('Leave empty or set to 0 for unlimited attendees', 'quick-event-management'); ?></p>
    </div>
    
    <div class="qem-meta-field">
        <label for="qem_event_registration_deadline"><?php _e('Registration Deadline', 'quick-event-management'); ?></label>
        <input type="text" id="qem_event_registration_deadline" name="qem_event_registration_deadline" value="<?php echo esc_attr($registration_deadline); ?>" class="qem-datepicker">
        <p class="description"><?php _e('Leave empty to allow registration until the event starts', 'quick-event-management'); ?></p>
    </div>
    
    <div class="qem-meta-field">
        <label for="qem_event_registration_fields"><?php _e('Required Registration Fields', 'quick-event-management'); ?></label>
        <div>
            <label>
                <input type="checkbox" name="qem_event_registration_fields[]" value="name" <?php echo in_array('name', $registration_fields) ? 'checked' : ''; ?>>
                <?php _e('Name', 'quick-event-management'); ?>
            </label>
            <label style="margin-left: 10px;">
                <input type="checkbox" name="qem_event_registration_fields[]" value="email" <?php echo in_array('email', $registration_fields) ? 'checked' : ''; ?>>
                <?php _e('Email', 'quick-event-management'); ?>
            </label>
            <label style="margin-left: 10px;">
                <input type="checkbox" name="qem_event_registration_fields[]" value="phone" <?php echo in_array('phone', $registration_fields) ? 'checked' : ''; ?>>
                <?php _e('Phone', 'quick-event-management'); ?>
            </label>
            <label style="margin-left: 10px;">
                <input type="checkbox" name="qem_event_registration_fields[]" value="address" <?php echo in_array('address', $registration_fields) ? 'checked' : ''; ?>>
                <?php _e('Address', 'quick-event-management'); ?>
            </label>
            <label style="margin-left: 10px;">
                <input type="checkbox" name="qem_event_registration_fields[]" value="company" <?php echo in_array('company', $registration_fields) ? 'checked' : ''; ?>>
                <?php _e('Company', 'quick-event-management'); ?>
            </label>
        </div>
    </div>
    
    <div class="qem-meta-field">
        <label for="qem_event_registration_approval">
            <input type="checkbox" id="qem_event_registration_approval" name="qem_event_registration_approval" value="1" <?php checked($registration_approval, 1); ?>>
            <?php _e('Require Approval for Registrations', 'quick-event-management'); ?>
        </label>
        <p class="description"><?php _e('If checked, registrations will be marked as "pending" until approved', 'quick-event-management'); ?></p>
    </div>
    
    <div class="qem-meta-field">
        <label for="qem_event_confirmation_email">
            <input type="checkbox" id="qem_event_confirmation_email" name="qem_event_confirmation_email" value="1" <?php checked($confirmation_email, 1); ?>>
            <?php _e('Send Confirmation Email to Attendees', 'quick-event-management'); ?>
        </label>
    </div>
    
    <div class="qem-meta-field">
        <label for="qem_event_notification_email">
            <input type="checkbox" id="qem_event_notification_email" name="qem_event_notification_email" value="1" <?php checked($notification_email, 1); ?>>
            <?php _e('Send Notification Email to Admin', 'quick-event-management'); ?>
        </label>
    </div>
    
    <div class="qem-meta-field">
        <label for="qem_event_custom_confirmation_message"><?php _e('Custom Confirmation Message', 'quick-event-management'); ?></label>
        <textarea id="qem_event_custom_confirmation_message" name="qem_event_custom_confirmation_message" rows="3"><?php echo esc_textarea($custom_confirmation_message); ?></textarea>
        <p class="description"><?php _e('This message will be displayed after successful registration and included in the confirmation email', 'quick-event-management'); ?></p>
    </div>
</div>
