<?php
/**
 * Template for event venue metabox
 *
 * @since      1.0.0
 */
?>

<div class="qem-meta-field">
    <label for="qem_event_venue"><?php _e('Select Venue', 'quick-event-management'); ?></label>
    <select id="qem_event_venue" name="qem_event_venue">
        <option value=""><?php _e('-- Select Venue --', 'quick-event-management'); ?></option>
        <?php foreach ($venues as $venue) : ?>
            <option value="<?php echo esc_attr($venue->ID); ?>" <?php selected($venue_id, $venue->ID); ?>>
                <?php echo esc_html($venue->post_title); ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

<div class="qem-meta-field">
    <p>
        <a href="#" id="qem-add-venue-toggle" class="button"><?php _e('Add New Venue', 'quick-event-management'); ?></a>
    </p>
    
    <div id="qem-add-venue-form" style="display: none; margin-top: 15px; padding: 15px; background: #f9f9f9; border: 1px solid #ddd;">
        <h4><?php _e('Add New Venue', 'quick-event-management'); ?></h4>
        
        <div class="qem-meta-field">
            <label for="qem_venue_name"><?php _e('Venue Name', 'quick-event-management'); ?> *</label>
            <input type="text" id="qem_venue_name" name="qem_venue_name" required>
        </div>
        
        <div class="qem-meta-field">
            <label for="qem_venue_address"><?php _e('Address', 'quick-event-management'); ?></label>
            <input type="text" id="qem_venue_address" name="qem_venue_address">
        </div>
        
        <div class="qem-meta-field" style="display: flex; gap: 10px;">
            <div style="flex: 1;">
                <label for="qem_venue_city"><?php _e('City', 'quick-event-management'); ?></label>
                <input type="text" id="qem_venue_city" name="qem_venue_city">
            </div>
            
            <div style="flex: 1;">
                <label for="qem_venue_state"><?php _e('State/Province', 'quick-event-management'); ?></label>
                <input type="text" id="qem_venue_state" name="qem_venue_state">
            </div>
        </div>
        
        <div class="qem-meta-field" style="display: flex; gap: 10px;">
            <div style="flex: 1;">
                <label for="qem_venue_zip"><?php _e('ZIP/Postal Code', 'quick-event-management'); ?></label>
                <input type="text" id="qem_venue_zip" name="qem_venue_zip">
            </div>
            
            <div style="flex: 1;">
                <label for="qem_venue_country"><?php _e('Country', 'quick-event-management'); ?></label>
                <input type="text" id="qem_venue_country" name="qem_venue_country">
            </div>
        </div>
        
        <div class="qem-meta-field">
            <label for="qem_venue_description"><?php _e('Description', 'quick-event-management'); ?></label>
            <textarea id="qem_venue_description" name="qem_venue_description" rows="3"></textarea>
        </div>
        
        <div class="qem-meta-field">
            <?php wp_nonce_field('qem_add_venue_nonce', 'qem_add_venue_nonce'); ?>
            <button type="submit" class="button button-primary"><?php _e('Add Venue', 'quick-event-management'); ?></button>
            <button type="button" class="button" onclick="jQuery('#qem-add-venue-form').hide();"><?php _e('Cancel', 'quick-event-management'); ?></button>
        </div>
    </div>
</div>

<p class="description"><?php _e('Select an existing venue or add a new one for your event.', 'quick-event-management'); ?></p>
