<?php
/**
 * Template for event details metabox
 *
 * @since      1.0.0
 */
?>

<div class="qem-meta-field qem-date-time-fields">
    <div class="qem-date-time-field">
        <label for="qem_event_start_date"><?php _e('Start Date', 'quick-event-management'); ?></label>
        <input type="text" id="qem_event_start_date" name="qem_event_start_date" value="<?php echo esc_attr($start_date); ?>" class="qem-datepicker" required>
    </div>
    
    <div class="qem-date-time-field">
        <label for="qem_event_start_time"><?php _e('Start Time', 'quick-event-management'); ?></label>
        <input type="text" id="qem_event_start_time" name="qem_event_start_time" value="<?php echo esc_attr($start_time); ?>" class="qem-timepicker">
    </div>
</div>

<div class="qem-meta-field qem-date-time-fields">
    <div class="qem-date-time-field">
        <label for="qem_event_end_date"><?php _e('End Date', 'quick-event-management'); ?></label>
        <input type="text" id="qem_event_end_date" name="qem_event_end_date" value="<?php echo esc_attr($end_date); ?>" class="qem-datepicker">
        <p class="description"><?php _e('Leave empty if it\'s a single-day event', 'quick-event-management'); ?></p>
    </div>
    
    <div class="qem-date-time-field">
        <label for="qem_event_end_time"><?php _e('End Time', 'quick-event-management'); ?></label>
        <input type="text" id="qem_event_end_time" name="qem_event_end_time" value="<?php echo esc_attr($end_time); ?>" class="qem-timepicker">
        <p class="description"><?php _e('Leave empty if not applicable', 'quick-event-management'); ?></p>
    </div>
</div>

<p class="description"><?php _e('Set the date and time for your event. The start date is required.', 'quick-event-management'); ?></p>
