(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 */

	$(document).ready(function() {
		// Initialize datepickers for event dates
		if ($.fn.datepicker) {
			$('.qem-datepicker').datepicker({
				dateFormat: 'yy-mm-dd',
				changeMonth: true,
				changeYear: true
			});
		}

		// Initialize timepickers for event times
		if ($.fn.timepicker) {
			$('.qem-timepicker').timepicker({
				timeFormat: 'HH:mm',
				interval: 15,
				dynamic: false,
				dropdown: true,
				scrollbar: true
			});
		}

		// Toggle registration settings based on registration enabled checkbox
		$('#qem_event_registration_enabled').on('change', function() {
			if ($(this).is(':checked')) {
				$('.qem-registration-settings').show();
			} else {
				$('.qem-registration-settings').hide();
			}
		}).trigger('change');

		// Handle registration status changes
		$('.qem-change-status').on('click', function(e) {
			e.preventDefault();
			
			var $this = $(this);
			var registrationId = $this.data('id');
			var newStatus = $this.data('status');
			var nonce = $this.data('nonce');
			
			if (confirm('Are you sure you want to change the status to ' + newStatus + '?')) {
				$.ajax({
					url: ajaxurl,
					type: 'POST',
					data: {
						action: 'qem_change_registration_status',
						registration_id: registrationId,
						status: newStatus,
						nonce: nonce
					},
					success: function(response) {
						if (response.success) {
							location.reload();
						} else {
							alert(response.data.message);
						}
					}
				});
			}
		});

		// Handle registration deletion
		$('.qem-delete-registration').on('click', function(e) {
			e.preventDefault();
			
			var $this = $(this);
			var registrationId = $this.data('id');
			var nonce = $this.data('nonce');
			
			if (confirm('Are you sure you want to delete this registration? This action cannot be undone.')) {
				$.ajax({
					url: ajaxurl,
					type: 'POST',
					data: {
						action: 'qem_delete_registration',
						registration_id: registrationId,
						nonce: nonce
					},
					success: function(response) {
						if (response.success) {
							location.reload();
						} else {
							alert(response.data.message);
						}
					}
				});
			}
		});

		// Add new venue form handling
		$('#qem-add-venue-toggle').on('click', function(e) {
			e.preventDefault();
			$('#qem-add-venue-form').toggle();
		});

		$('#qem-add-venue-form').on('submit', function(e) {
			e.preventDefault();
			
			var $form = $(this);
			var $submitButton = $form.find('button[type="submit"]');
			var formData = $form.serialize();
			
			$submitButton.prop('disabled', true).text('Adding...');
			
			$.ajax({
				url: ajaxurl,
				type: 'POST',
				data: formData + '&action=qem_add_venue',
				success: function(response) {
					if (response.success) {
						// Add new venue to dropdown and select it
						var $venueSelect = $('#qem_event_venue');
						$venueSelect.append($('<option>', {
							value: response.data.venue_id,
							text: response.data.venue_name
						}));
						$venueSelect.val(response.data.venue_id);
						
						// Reset and hide form
						$form[0].reset();
						$form.hide();
						
						// Show success message
						$('<div class="notice notice-success is-dismissible"><p>' + response.data.message + '</p></div>')
							.insertBefore($form)
							.delay(3000)
							.fadeOut(function() {
								$(this).remove();
							});
					} else {
						// Show error message
						$('<div class="notice notice-error is-dismissible"><p>' + response.data.message + '</p></div>')
							.insertBefore($form);
					}
					
					$submitButton.prop('disabled', false).text('Add Venue');
				}
			});
		});

		// Export registrations
		$('#qem-export-registrations').on('click', function(e) {
			e.preventDefault();
			
			var eventId = $(this).data('event-id');
			var nonce = $(this).data('nonce');
			
			window.location.href = ajaxurl + '?action=qem_export_registrations&event_id=' + eventId + '&nonce=' + nonce;
		});
	});

})( jQuery );
