# Quick Event Management System

A comprehensive yet lightweight WordPress plugin that enables bloggers and site owners to manage events, registrations, and venues fully within WordPress without relying on external APIs. Developed by Quick Plugins Team.

## Description

Quick Event Management System is a self-contained WordPress plugin designed to provide core event management features suitable for bloggers, businesses, and organizations. The plugin operates fully within WordPress and doesn't rely on any external APIs.

### Key Features

- **Custom Post Types**: Events and Venues
- **Custom Taxonomies**: Event Categories and Tags
- **Event Details**: Start/end dates and times, venue association, maximum attendees, and registration enablement
- **Registration System**: Database table for storing registrations, attendee management, status updates, and email notifications
- **Admin Interface**: Metaboxes for event details, venue selection, registration settings, and registrations overview
- **Frontend Display**: Shortcodes for listing events (list/grid), single event display, registration forms, and event calendar
- **AJAX Registration**: Form submission with nonce security
- **Settings Page**: Configure plugin options like event slug, date/time formats, email subjects, and notification preferences

## Installation

1. Upload the `quick-event-management` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Configure the plugin settings under 'Events > Settings'

## Usage

### Creating Events

1. Go to 'Events > Add New' in your WordPress admin
2. Enter the event title and description
3. Set the event details (date, time, venue)
4. Configure registration settings if needed
5. Publish the event

### Creating Venues

1. Go to 'Events > Venues > Add New' in your WordPress admin
2. Enter the venue name and details
3. Publish the venue
4. Venues can also be created directly when creating/editing an event

### Managing Registrations

1. Go to 'Events > All Events' and edit an event
2. Scroll down to the 'Registrations' metabox
3. View, confirm, or cancel registrations
4. Export registrations to CSV if needed

### Displaying Events on Your Site

Use the following shortcodes to display events on your site:

#### Events List/Grid
```
[qem_events view="list" limit="10" category="" tag="" columns="3" excerpt="true" filter="true" pagination="true"]
```

Parameters:
- `view`: Display style - "list" or "grid" (default: "list")
- `limit`: Number of events to display (default: 10)
- `category`: Filter by category slug (default: empty)
- `tag`: Filter by tag slug (default: empty)
- `columns`: Number of columns for grid view (default: 3)
- `excerpt`: Show excerpt - "true" or "false" (default: "true")
- `filter`: Show category/time filter - "true" or "false" (default: "false")
- `pagination`: Show pagination - "true" or "false" (default: "true")

#### Single Event
```
[qem_event id="123"]
```

Parameters:
- `id`: Event ID (required)

#### Registration Form
```
[qem_registration_form id="123"]
```

Parameters:
- `id`: Event ID (required)

#### Calendar
```
[qem_calendar category="" tag=""]
```

Parameters:
- `category`: Filter by category slug (default: empty)
- `tag`: Filter by tag slug (default: empty)

## Customization

### Templates

The plugin templates can be overridden by copying the template files from the plugin's `public/partials` directory to your theme's `quick-event-management` directory.

### CSS

You can customize the plugin's appearance by adding custom CSS to your theme or by using a custom CSS plugin.

### Hooks and Filters

The plugin provides various hooks and filters for developers to extend its functionality. Documentation for these will be provided in future updates.

## Frequently Asked Questions

**Q: Can I use this plugin without allowing registrations?**
A: Yes, registrations can be enabled or disabled for each event individually.

**Q: Does this plugin support recurring events?**
A: No, the current version does not support recurring events. Each event must be created separately.

**Q: Can I customize the registration form?**
A: Yes, you can choose which fields are required in the event settings. For more advanced customization, you can override the template files.

## License

This plugin is licensed under the GPL v2 or later.

## Credits

Developed as a comprehensive WordPress event management solution that operates fully within WordPress without external dependencies.
