<?php
/**
 * Fired during plugin deactivation
 *
 * @link       https://plugins.quickpr.co/
 * @since      1.0.0
 *
 * @package    Quick_Push_Notifications
 * @subpackage Quick_Push_Notifications/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Quick_Push_Notifications
 * @subpackage Quick_Push_Notifications/includes
 * @author     Quick LLC <info@quickpr.co>
 */
class Quick_Push_Notifications_Deactivator {

    /**
     * Deactivate the plugin.
     *
     * Clear scheduled events and perform any cleanup needed.
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        // Clear scheduled events
        wp_clear_scheduled_hook('qpn_send_scheduled_notifications');
    }
}
