<?php
/**
 * Provide a admin area view for the plugin settings
 *
 * This file is used to markup the admin-facing settings page.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Push_Notifications
 * @subpackage Quick_Push_Notifications/admin/partials
 */
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <?php
    // Show settings saved message
    if (isset($_GET['settings-updated'])) {
        echo '<div class="notice notice-success is-dismissible"><p>' . __('Settings saved successfully.', 'quick-push-notifications') . '</p></div>';
    }
    ?>
    
    <div class="qpn-settings-form">
        <form method="post" action="options.php">
            <?php
            settings_fields($this->plugin_name . '-settings');
            do_settings_sections($this->plugin_name . '-settings');
            ?>
            
            <!-- Firebase Settings -->
            <div class="qpn-settings-section">
                <h2><?php _e('Firebase Configuration', 'quick-push-notifications'); ?></h2>
                <p><?php _e('Enter your Firebase project credentials to enable push notifications.', 'quick-push-notifications'); ?></p>
                
                <table class="qpn-form-table">
                    <tr>
                        <th scope="row">
                            <label for="qpn_firebase_api_key"><?php _e('API Key', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_firebase_api_key" name="qpn_firebase_api_key" value="<?php echo esc_attr(get_option('qpn_firebase_api_key', '')); ?>" class="regular-text">
                            <p class="qpn-form-description"><?php _e('Your Firebase project API key.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_firebase_auth_domain"><?php _e('Auth Domain', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_firebase_auth_domain" name="qpn_firebase_auth_domain" value="<?php echo esc_attr(get_option('qpn_firebase_auth_domain', '')); ?>" class="regular-text">
                            <p class="qpn-form-description"><?php _e('Your Firebase project auth domain.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_firebase_project_id"><?php _e('Project ID', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_firebase_project_id" name="qpn_firebase_project_id" value="<?php echo esc_attr(get_option('qpn_firebase_project_id', '')); ?>" class="regular-text">
                            <p class="qpn-form-description"><?php _e('Your Firebase project ID.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_firebase_storage_bucket"><?php _e('Storage Bucket', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_firebase_storage_bucket" name="qpn_firebase_storage_bucket" value="<?php echo esc_attr(get_option('qpn_firebase_storage_bucket', '')); ?>" class="regular-text">
                            <p class="qpn-form-description"><?php _e('Your Firebase project storage bucket.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_firebase_messaging_sender_id"><?php _e('Messaging Sender ID', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_firebase_messaging_sender_id" name="qpn_firebase_messaging_sender_id" value="<?php echo esc_attr(get_option('qpn_firebase_messaging_sender_id', '')); ?>" class="regular-text">
                            <p class="qpn-form-description"><?php _e('Your Firebase project messaging sender ID.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_firebase_app_id"><?php _e('App ID', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_firebase_app_id" name="qpn_firebase_app_id" value="<?php echo esc_attr(get_option('qpn_firebase_app_id', '')); ?>" class="regular-text">
                            <p class="qpn-form-description"><?php _e('Your Firebase project app ID.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_firebase_server_key"><?php _e('Server Key', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_firebase_server_key" name="qpn_firebase_server_key" value="<?php echo esc_attr(get_option('qpn_firebase_server_key', '')); ?>" class="regular-text">
                            <p class="qpn-form-description"><?php _e('Your Firebase project server key (from Project Settings > Cloud Messaging).', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                </table>
                
                <div class="qpn-firebase-instructions">
                    <h3><?php _e('How to Get Firebase Credentials', 'quick-push-notifications'); ?></h3>
                    <ol>
                        <li><?php _e('Go to <a href="https://console.firebase.google.com/" target="_blank">Firebase Console</a> and create a new project or select an existing one.', 'quick-push-notifications'); ?></li>
                        <li><?php _e('Click on the gear icon next to "Project Overview" and select "Project settings".', 'quick-push-notifications'); ?></li>
                        <li><?php _e('In the "General" tab, scroll down to "Your apps" section and click on the web app icon (</>) to add a web app if you haven\'t already.', 'quick-push-notifications'); ?></li>
                        <li><?php _e('Register your app with a nickname and click "Register app".', 'quick-push-notifications'); ?></li>
                        <li><?php _e('Copy the Firebase configuration values and paste them into the fields above.', 'quick-push-notifications'); ?></li>
                        <li><?php _e('Go to the "Cloud Messaging" tab and copy the "Server key" into the Server Key field above.', 'quick-push-notifications'); ?></li>
                    </ol>
                </div>
            </div>
            
            <!-- Notification Settings -->
            <div class="qpn-settings-section">
                <h2><?php _e('Notification Settings', 'quick-push-notifications'); ?></h2>
                
                <table class="qpn-form-table">
                    <tr>
                        <th scope="row">
                            <label for="qpn_notification_icon"><?php _e('Default Notification Icon', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="url" id="qpn_notification_icon" name="qpn_notification_icon" value="<?php echo esc_url(get_option('qpn_notification_icon', '')); ?>" class="regular-text">
                            <p class="qpn-form-description"><?php _e('URL to the default icon for notifications. Recommended size: 192x192px.', 'quick-push-notifications'); ?></p>
                            <button type="button" class="button qpn-media-upload" data-target="qpn_notification_icon">
                                <?php _e('Select Image', 'quick-push-notifications'); ?>
                            </button>
                            <div id="qpn_notification_icon_preview" class="qpn-image-preview">
                                <?php if (get_option('qpn_notification_icon', '')) : ?>
                                    <img src="<?php echo esc_url(get_option('qpn_notification_icon', '')); ?>" alt="<?php _e('Notification Icon', 'quick-push-notifications'); ?>">
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Welcome Notification Settings -->
            <div class="qpn-settings-section">
                <h2><?php _e('Welcome Notification', 'quick-push-notifications'); ?></h2>
                <p><?php _e('Configure the welcome notification that is sent to new subscribers.', 'quick-push-notifications'); ?></p>
                
                <table class="qpn-form-table">
                    <tr>
                        <th scope="row">
                            <label for="qpn_welcome_notification_enabled"><?php _e('Enable Welcome Notification', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <select id="qpn_welcome_notification_enabled" name="qpn_welcome_notification_enabled">
                                <option value="yes" <?php selected(get_option('qpn_welcome_notification_enabled', 'yes'), 'yes'); ?>><?php _e('Yes', 'quick-push-notifications'); ?></option>
                                <option value="no" <?php selected(get_option('qpn_welcome_notification_enabled', 'yes'), 'no'); ?>><?php _e('No', 'quick-push-notifications'); ?></option>
                            </select>
                            <p class="qpn-form-description"><?php _e('Send a welcome notification to new subscribers.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_welcome_notification_title"><?php _e('Welcome Notification Title', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_welcome_notification_title" name="qpn_welcome_notification_title" value="<?php echo esc_attr(get_option('qpn_welcome_notification_title', 'Thanks for subscribing!')); ?>" class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_welcome_notification_message"><?php _e('Welcome Notification Message', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <textarea id="qpn_welcome_notification_message" name="qpn_welcome_notification_message" rows="3" class="regular-text"><?php echo esc_textarea(get_option('qpn_welcome_notification_message', 'You will now receive notifications from our site.')); ?></textarea>
                        </td>
                    </tr>
                </table>
            </div>
            
            <!-- Auto-Push Settings -->
            <div class="qpn-settings-section">
                <h2><?php _e('Auto-Push Notifications', 'quick-push-notifications'); ?></h2>
                <p><?php _e('Configure automatic push notifications for new content.', 'quick-push-notifications'); ?></p>
                
                <table class="qpn-form-table">
                    <tr>
                        <th scope="row">
                            <label for="qpn_auto_push_enabled"><?php _e('Enable Auto-Push', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <select id="qpn_auto_push_enabled" name="qpn_auto_push_enabled">
                                <option value="yes" <?php selected(get_option('qpn_auto_push_enabled', 'no'), 'yes'); ?>><?php _e('Yes', 'quick-push-notifications'); ?></option>
                                <option value="no" <?php selected(get_option('qpn_auto_push_enabled', 'no'), 'no'); ?>><?php _e('No', 'quick-push-notifications'); ?></option>
                            </select>
                            <p class="qpn-form-description"><?php _e('Automatically create notifications for new content.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label><?php _e('Post Types', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <?php
                            $post_types = get_post_types(array('public' => true), 'objects');
                            $selected_post_types = get_option('qpn_auto_push_post_types', array('post'));
                            
                            foreach ($post_types as $post_type) :
                                $checked = in_array($post_type->name, $selected_post_types) ? 'checked' : '';
                            ?>
                                <label>
                                    <input type="checkbox" name="qpn_auto_push_post_types[]" value="<?php echo esc_attr($post_type->name); ?>" <?php echo $checked; ?>>
                                    <?php echo esc_html($post_type->label); ?>
                                </label><br>
                            <?php endforeach; ?>
                            <p class="qpn-form-description"><?php _e('Select which post types should trigger auto-push notifications.', 'quick-push-notifications'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_auto_push_title"><?php _e('Notification Title Template', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="qpn_auto_push_title" name="qpn_auto_push_title" value="<?php echo esc_attr(get_option('qpn_auto_push_title', 'New post: {post_title}')); ?>" class="regular-text">
                            <p class="qpn-form-description">
                                <?php _e('Available placeholders: {post_title}, {site_name}', 'quick-push-notifications'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_auto_push_message"><?php _e('Notification Message Template', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <textarea id="qpn_auto_push_message" name="qpn_auto_push_message" rows="3" class="regular-text"><?php echo esc_textarea(get_option('qpn_auto_push_message', '{post_excerpt}')); ?></textarea>
                            <p class="qpn-form-description">
                                <?php _e('Available placeholders: {post_title}, {post_excerpt}, {site_name}', 'quick-push-notifications'); ?>
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="qpn_auto_push_send"><?php _e('Auto-Send Notifications', 'quick-push-notifications'); ?></label>
                        </th>
                        <td>
                            <select id="qpn_auto_push_send" name="qpn_auto_push_send">
                                <option value="yes" <?php selected(get_option('qpn_auto_push_send', 'no'), 'yes'); ?>><?php _e('Yes', 'quick-push-notifications'); ?></option>
                                <option value="no" <?php selected(get_option('qpn_auto_push_send', 'no'), 'no'); ?>><?php _e('No', 'quick-push-notifications'); ?></option>
                            </select>
                            <p class="qpn-form-description">
                                <?php _e('Automatically send notifications without manual approval. If set to "No", notifications will be created as drafts.', 'quick-push-notifications'); ?>
                            </p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <?php submit_button(__('Save Settings', 'quick-push-notifications'), 'primary', 'submit', true); ?>
        </form>
    </div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Media uploader
    $('.qpn-media-upload').click(function(e) {
        e.preventDefault();
        
        var button = $(this);
        var targetField = button.data('target');
        
        var mediaUploader = wp.media({
            title: '<?php _e('Select Image', 'quick-push-notifications'); ?>',
            button: {
                text: '<?php _e('Use this image', 'quick-push-notifications'); ?>'
            },
            multiple: false
        });
        
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            $('#' + targetField).val(attachment.url);
            $('#' + targetField + '_preview').html('<img src="' + attachment.url + '" alt="<?php _e('Preview', 'quick-push-notifications'); ?>">');
        });
        
        mediaUploader.open();
    });
});
</script>
