<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Quick_Push_Notifications
 * @subpackage Quick_Push_Notifications/admin/partials
 */

// Get statistics
global $wpdb;
$subscribers_table = $wpdb->prefix . 'qpn_subscribers';
$notifications_table = $wpdb->prefix . 'qpn_notifications';
$logs_table = $wpdb->prefix . 'qpn_notification_logs';

$total_subscribers = $wpdb->get_var("SELECT COUNT(*) FROM $subscribers_table");
$total_notifications = $wpdb->get_var("SELECT COUNT(*) FROM $notifications_table");
$total_sent = $wpdb->get_var("SELECT COUNT(*) FROM $logs_table WHERE status = 'sent'");

// Get recent subscribers
$recent_subscribers = $wpdb->get_results(
    "SELECT * FROM $subscribers_table ORDER BY created_at DESC LIMIT 5",
    ARRAY_A
);

// Get recent notifications
$recent_notifications = $wpdb->get_results(
    "SELECT * FROM $notifications_table ORDER BY created_at DESC LIMIT 5",
    ARRAY_A
);

// Get browser stats
$browser_stats = $wpdb->get_results(
    "SELECT browser, COUNT(*) as count FROM $subscribers_table GROUP BY browser ORDER BY count DESC",
    ARRAY_A
);

// Get OS stats
$os_stats = $wpdb->get_results(
    "SELECT os, COUNT(*) as count FROM $subscribers_table GROUP BY os ORDER BY count DESC",
    ARRAY_A
);

// Get device type stats
$device_stats = $wpdb->get_results(
    "SELECT device_type, COUNT(*) as count FROM $subscribers_table GROUP BY device_type ORDER BY count DESC",
    ARRAY_A
);
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="qpn-dashboard">
        <!-- Statistics Cards -->
        <div class="qpn-stats-cards">
            <div class="qpn-card">
                <div class="qpn-card-icon">
                    <span class="dashicons dashicons-groups"></span>
                </div>
                <div class="qpn-card-content">
                    <h3><?php echo esc_html($total_subscribers); ?></h3>
                    <p><?php _e('Total Subscribers', 'quick-push-notifications'); ?></p>
                </div>
            </div>
            
            <div class="qpn-card">
                <div class="qpn-card-icon">
                    <span class="dashicons dashicons-megaphone"></span>
                </div>
                <div class="qpn-card-content">
                    <h3><?php echo esc_html($total_notifications); ?></h3>
                    <p><?php _e('Total Notifications', 'quick-push-notifications'); ?></p>
                </div>
            </div>
            
            <div class="qpn-card">
                <div class="qpn-card-icon">
                    <span class="dashicons dashicons-email-alt"></span>
                </div>
                <div class="qpn-card-content">
                    <h3><?php echo esc_html($total_sent); ?></h3>
                    <p><?php _e('Notifications Sent', 'quick-push-notifications'); ?></p>
                </div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="qpn-quick-actions">
            <h2><?php _e('Quick Actions', 'quick-push-notifications'); ?></h2>
            <div class="qpn-actions-buttons">
                <a href="<?php echo admin_url('admin.php?page=quick-push-notifications-compose'); ?>" class="button button-primary">
                    <span class="dashicons dashicons-edit"></span> <?php _e('Compose Notification', 'quick-push-notifications'); ?>
                </a>
                <a href="<?php echo admin_url('admin.php?page=quick-push-notifications-subscribers'); ?>" class="button">
                    <span class="dashicons dashicons-groups"></span> <?php _e('Manage Subscribers', 'quick-push-notifications'); ?>
                </a>
                <a href="<?php echo admin_url('admin.php?page=quick-push-notifications-settings'); ?>" class="button">
                    <span class="dashicons dashicons-admin-settings"></span> <?php _e('Settings', 'quick-push-notifications'); ?>
                </a>
            </div>
        </div>
        
        <div class="qpn-dashboard-columns">
            <!-- Recent Subscribers -->
            <div class="qpn-dashboard-column">
                <div class="qpn-dashboard-box">
                    <h2><?php _e('Recent Subscribers', 'quick-push-notifications'); ?></h2>
                    <?php if (!empty($recent_subscribers)) : ?>
                        <table class="qpn-table">
                            <thead>
                                <tr>
                                    <th><?php _e('Browser', 'quick-push-notifications'); ?></th>
                                    <th><?php _e('OS', 'quick-push-notifications'); ?></th>
                                    <th><?php _e('Device', 'quick-push-notifications'); ?></th>
                                    <th><?php _e('Date', 'quick-push-notifications'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_subscribers as $subscriber) : ?>
                                    <tr>
                                        <td><?php echo esc_html($subscriber['browser']); ?></td>
                                        <td><?php echo esc_html($subscriber['os']); ?></td>
                                        <td><?php echo esc_html($subscriber['device_type']); ?></td>
                                        <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($subscriber['created_at']))); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        <p class="qpn-view-all">
                            <a href="<?php echo admin_url('admin.php?page=quick-push-notifications-subscribers'); ?>">
                                <?php _e('View All Subscribers', 'quick-push-notifications'); ?> →
                            </a>
                        </p>
                    <?php else : ?>
                        <p><?php _e('No subscribers yet.', 'quick-push-notifications'); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Recent Notifications -->
            <div class="qpn-dashboard-column">
                <div class="qpn-dashboard-box">
                    <h2><?php _e('Recent Notifications', 'quick-push-notifications'); ?></h2>
                    <?php if (!empty($recent_notifications)) : ?>
                        <table class="qpn-table">
                            <thead>
                                <tr>
                                    <th><?php _e('Title', 'quick-push-notifications'); ?></th>
                                    <th><?php _e('Status', 'quick-push-notifications'); ?></th>
                                    <th><?php _e('Date', 'quick-push-notifications'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_notifications as $notification) : ?>
                                    <tr>
                                        <td><?php echo esc_html($notification['title']); ?></td>
                                        <td>
                                            <span class="qpn-status qpn-status-<?php echo esc_attr($notification['status']); ?>">
                                                <?php echo esc_html(ucfirst($notification['status'])); ?>
                                            </span>
                                        </td>
                                        <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($notification['created_at']))); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        <p class="qpn-view-all">
                            <a href="<?php echo admin_url('admin.php?page=quick-push-notifications-notifications'); ?>">
                                <?php _e('View All Notifications', 'quick-push-notifications'); ?> →
                            </a>
                        </p>
                    <?php else : ?>
                        <p><?php _e('No notifications yet.', 'quick-push-notifications'); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Subscriber Stats -->
        <div class="qpn-dashboard-box qpn-stats-box">
            <h2><?php _e('Subscriber Statistics', 'quick-push-notifications'); ?></h2>
            
            <div class="qpn-stats-columns">
                <!-- Browser Stats -->
                <div class="qpn-stats-column">
                    <h3><?php _e('Browsers', 'quick-push-notifications'); ?></h3>
                    <?php if (!empty($browser_stats)) : ?>
                        <ul class="qpn-stats-list">
                            <?php foreach ($browser_stats as $browser) : ?>
                                <li>
                                    <span class="qpn-stats-label"><?php echo esc_html($browser['browser']); ?></span>
                                    <span class="qpn-stats-count"><?php echo esc_html($browser['count']); ?></span>
                                    <div class="qpn-stats-bar">
                                        <div class="qpn-stats-bar-fill" style="width: <?php echo esc_attr(($browser['count'] / $total_subscribers) * 100); ?>%;"></div>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else : ?>
                        <p><?php _e('No data available.', 'quick-push-notifications'); ?></p>
                    <?php endif; ?>
                </div>
                
                <!-- OS Stats -->
                <div class="qpn-stats-column">
                    <h3><?php _e('Operating Systems', 'quick-push-notifications'); ?></h3>
                    <?php if (!empty($os_stats)) : ?>
                        <ul class="qpn-stats-list">
                            <?php foreach ($os_stats as $os) : ?>
                                <li>
                                    <span class="qpn-stats-label"><?php echo esc_html($os['os']); ?></span>
                                    <span class="qpn-stats-count"><?php echo esc_html($os['count']); ?></span>
                                    <div class="qpn-stats-bar">
                                        <div class="qpn-stats-bar-fill" style="width: <?php echo esc_attr(($os['count'] / $total_subscribers) * 100); ?>%;"></div>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else : ?>
                        <p><?php _e('No data available.', 'quick-push-notifications'); ?></p>
                    <?php endif; ?>
                </div>
                
                <!-- Device Stats -->
                <div class="qpn-stats-column">
                    <h3><?php _e('Device Types', 'quick-push-notifications'); ?></h3>
                    <?php if (!empty($device_stats)) : ?>
                        <ul class="qpn-stats-list">
                            <?php foreach ($device_stats as $device) : ?>
                                <li>
                                    <span class="qpn-stats-label"><?php echo esc_html($device['device_type']); ?></span>
                                    <span class="qpn-stats-count"><?php echo esc_html($device['count']); ?></span>
                                    <div class="qpn-stats-bar">
                                        <div class="qpn-stats-bar-fill" style="width: <?php echo esc_attr(($device['count'] / $total_subscribers) * 100); ?>%;"></div>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else : ?>
                        <p><?php _e('No data available.', 'quick-push-notifications'); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Getting Started -->
        <?php if ($total_subscribers == 0 || $total_notifications == 0) : ?>
        <div class="qpn-dashboard-box qpn-getting-started">
            <h2><?php _e('Getting Started', 'quick-push-notifications'); ?></h2>
            <ol class="qpn-steps">
                <li>
                    <h3><?php _e('1. Configure Firebase', 'quick-push-notifications'); ?></h3>
                    <p><?php _e('Set up your Firebase project and enter your credentials in the Settings page.', 'quick-push-notifications'); ?></p>
                    <a href="<?php echo admin_url('admin.php?page=quick-push-notifications-settings'); ?>" class="button">
                        <?php _e('Go to Settings', 'quick-push-notifications'); ?>
                    </a>
                </li>
                <li>
                    <h3><?php _e('2. Add Subscription Button', 'quick-push-notifications'); ?></h3>
                    <p><?php _e('Add a subscription button to your website using the shortcode:', 'quick-push-notifications'); ?></p>
                    <code>[quick_push_notifications_button]</code>
                </li>
                <li>
                    <h3><?php _e('3. Send Your First Notification', 'quick-push-notifications'); ?></h3>
                    <p><?php _e('Once you have subscribers, compose and send your first notification.', 'quick-push-notifications'); ?></p>
                    <a href="<?php echo admin_url('admin.php?page=quick-push-notifications-compose'); ?>" class="button">
                        <?php _e('Compose Notification', 'quick-push-notifications'); ?>
                    </a>
                </li>
            </ol>
        </div>
        <?php endif; ?>
    </div>
</div>
