<?php
/**
 * Fired during plugin deactivation
 *
 * @link       https://plugins.quickpr.co/
 * @since      1.0.0
 *
 * @package    Quick_Custom_Admin
 * @subpackage Quick_Custom_Admin/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Quick_Custom_Admin
 * @subpackage Quick_Custom_Admin/includes
 * @author     Quick LLC <info@quickpr.co>
 */
class Quick_Custom_Admin_Deactivator {

    /**
     * Clean up on plugin deactivation.
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        // We don't delete the options on deactivation
        // This allows users to keep their settings if they reactivate the plugin
        
        // Clear any transients we might have set
        delete_transient('quick_custom_admin_notices');
    }
}
