<?php
/**
 * Fired during plugin activation
 *
 * @link       https://plugins.quickpr.co/
 * @since      1.0.0
 *
 * @package    Quick_Custom_Admin
 * @subpackage Quick_Custom_Admin/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Quick_Custom_Admin
 * @subpackage Quick_Custom_Admin/includes
 * @author     Quick LLC <info@quickpr.co>
 */
class Quick_Custom_Admin_Activator {

    /**
     * Set default options on activation.
     *
     * @since    1.0.0
     */
    public static function activate() {
        // Default options
        $default_options = array(
            // White labeling options
            'white_label_enabled' => false,
            'custom_admin_title' => get_bloginfo('name') . ' Admin',
            'custom_login_logo' => '',
            'custom_login_logo_url' => home_url(),
            'custom_login_logo_title' => get_bloginfo('name'),
            'replace_wp_logo' => false,
            'custom_admin_logo' => '',
            'custom_admin_footer_text' => 'Thank you for creating with <a href="https://wordpress.org/">WordPress</a>.',
            'hide_wp_version' => false,
            'custom_version_text' => '',
            
            // Dashboard customization
            'remove_dashboard_widgets' => array(
                'dashboard_activity' => false,
                'dashboard_right_now' => false,
                'dashboard_quick_press' => false,
                'dashboard_primary' => false,
                'dashboard_site_health' => false,
                'dashboard_at_a_glance' => false,
            ),
            'custom_dashboard_widgets' => array(),
            
            // Admin menu customization
            'hide_menu_items' => array(),
            'rename_menu_items' => array(),
            'reorder_menu_items' => array(),
            
            // Role-based restrictions
            'role_restrictions' => array(),
            
            // Admin color schemes
            'force_color_scheme' => false,
            'default_color_scheme' => 'default',
            'custom_color_schemes' => array(),
            
            // Admin notices
            'custom_admin_notices' => array(),
            
            // Help tabs
            'custom_help_tabs' => array(),
            
            // Admin columns
            'custom_admin_columns' => array(),
        );
        
        // Add default options to database if they don't exist
        if (!get_option('quick_custom_admin_options')) {
            add_option('quick_custom_admin_options', $default_options);
        }
    }
}
