<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://plugins.quickpr.co/
 * @since      1.0.0
 *
 * @package    Quick_Custom_Admin
 * @subpackage Quick_Custom_Admin/admin/partials
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Get plugin options
$options = get_option('quick_custom_admin_options', array());
?>

<div class="wrap quick-custom-admin-wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <h2 class="nav-tab-wrapper quick-custom-admin-tabs">
        <a href="#white-label" class="nav-tab nav-tab-active"><?php _e('White Label', 'quick-custom-admin'); ?></a>
        <a href="#login-screen" class="nav-tab"><?php _e('Login Screen', 'quick-custom-admin'); ?></a>
        <a href="#admin-bar" class="nav-tab"><?php _e('Admin Bar', 'quick-custom-admin'); ?></a>
        <a href="#footer" class="nav-tab"><?php _e('Footer', 'quick-custom-admin'); ?></a>
    </h2>
    
    <form method="post" action="options.php">
        <?php settings_fields('quick_custom_admin_options'); ?>
        
        <!-- White Label Tab -->
        <div id="white-label" class="quick-custom-admin-tab-content">
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="white_label_enabled"><?php _e('Enable White Labeling', 'quick-custom-admin'); ?></label>
                    </th>
                    <td>
                        <label class="quick-custom-admin-toggle">
                            <input type="checkbox" id="white_label_enabled" name="quick_custom_admin_options[white_label_enabled]" value="1" <?php checked(isset($options['white_label_enabled']) ? $options['white_label_enabled'] : false); ?> class="quick-custom-admin-toggle-section" data-target="#white-label-options">
                            <span class="quick-custom-admin-toggle-slider"></span>
                        </label>
                        <p class="description"><?php _e('Enable white labeling features across the WordPress admin.', 'quick-custom-admin'); ?></p>
                    </td>
                </tr>
            </table>
            
            <div id="white-label-options">
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="custom_admin_title"><?php _e('Admin Title', 'quick-custom-admin'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="custom_admin_title" name="quick_custom_admin_options[custom_admin_title]" value="<?php echo esc_attr(isset($options['custom_admin_title']) ? $options['custom_admin_title'] : ''); ?>" class="regular-text">
                            <p class="description"><?php _e('Replace "WordPress" in the admin title with your custom text.', 'quick-custom-admin'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- Login Screen Tab -->
        <div id="login-screen" class="quick-custom-admin-tab-content" style="display: none;">
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="custom_login_logo"><?php _e('Login Logo', 'quick-custom-admin'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="custom_login_logo" name="quick_custom_admin_options[custom_login_logo]" value="<?php echo esc_url(isset($options['custom_login_logo']) ? $options['custom_login_logo'] : ''); ?>" class="regular-text quick-custom-admin-image-field">
                        <button class="button quick-custom-admin-upload-button"><?php _e('Upload Image', 'quick-custom-admin'); ?></button>
                        <a href="#" class="quick-custom-admin-remove-image" <?php echo empty($options['custom_login_logo']) ? 'style="display:none;"' : ''; ?>><?php _e('Remove Image', 'quick-custom-admin'); ?></a>
                        <div class="quick-custom-admin-image-preview" <?php echo empty($options['custom_login_logo']) ? 'style="display:none;"' : ''; ?>>
                            <?php if (!empty($options['custom_login_logo'])) : ?>
                                <img src="<?php echo esc_url($options['custom_login_logo']); ?>" alt="">
                            <?php endif; ?>
                        </div>
                        <p class="description"><?php _e('Upload a custom logo for the WordPress login screen. Recommended size: 320px × 80px.', 'quick-custom-admin'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="custom_login_logo_url"><?php _e('Logo URL', 'quick-custom-admin'); ?></label>
                    </th>
                    <td>
                        <input type="url" id="custom_login_logo_url" name="quick_custom_admin_options[custom_login_logo_url]" value="<?php echo esc_url(isset($options['custom_login_logo_url']) ? $options['custom_login_logo_url'] : home_url()); ?>" class="regular-text">
                        <p class="description"><?php _e('The URL that users will be redirected to when clicking the login logo.', 'quick-custom-admin'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="custom_login_logo_title"><?php _e('Logo Title', 'quick-custom-admin'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="custom_login_logo_title" name="quick_custom_admin_options[custom_login_logo_title]" value="<?php echo esc_attr(isset($options['custom_login_logo_title']) ? $options['custom_login_logo_title'] : get_bloginfo('name')); ?>" class="regular-text">
                        <p class="description"><?php _e('The title attribute for the login logo.', 'quick-custom-admin'); ?></p>
                    </td>
                </tr>
            </table>
        </div>
        
        <!-- Admin Bar Tab -->
        <div id="admin-bar" class="quick-custom-admin-tab-content" style="display: none;">
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="replace_wp_logo"><?php _e('Replace WordPress Logo', 'quick-custom-admin'); ?></label>
                    </th>
                    <td>
                        <label class="quick-custom-admin-toggle">
                            <input type="checkbox" id="replace_wp_logo" name="quick_custom_admin_options[replace_wp_logo]" value="1" <?php checked(isset($options['replace_wp_logo']) ? $options['replace_wp_logo'] : false); ?> class="quick-custom-admin-toggle-section" data-target="#admin-logo-options">
                            <span class="quick-custom-admin-toggle-slider"></span>
                        </label>
                        <p class="description"><?php _e('Replace the WordPress logo in the admin bar.', 'quick-custom-admin'); ?></p>
                    </td>
                </tr>
            </table>
            
            <div id="admin-logo-options">
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="custom_admin_logo"><?php _e('Admin Bar Logo', 'quick-custom-admin'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="custom_admin_logo" name="quick_custom_admin_options[custom_admin_logo]" value="<?php echo esc_url(isset($options['custom_admin_logo']) ? $options['custom_admin_logo'] : ''); ?>" class="regular-text quick-custom-admin-image-field">
                            <button class="button quick-custom-admin-upload-button"><?php _e('Upload Image', 'quick-custom-admin'); ?></button>
                            <a href="#" class="quick-custom-admin-remove-image" <?php echo empty($options['custom_admin_logo']) ? 'style="display:none;"' : ''; ?>><?php _e('Remove Image', 'quick-custom-admin'); ?></a>
                            <div class="quick-custom-admin-image-preview" <?php echo empty($options['custom_admin_logo']) ? 'style="display:none;"' : ''; ?>>
                                <?php if (!empty($options['custom_admin_logo'])) : ?>
                                    <img src="<?php echo esc_url($options['custom_admin_logo']); ?>" alt="">
                                <?php endif; ?>
                            </div>
                            <p class="description"><?php _e('Upload a custom logo for the admin bar. Recommended size: 20px height.', 'quick-custom-admin'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- Footer Tab -->
        <div id="footer" class="quick-custom-admin-tab-content" style="display: none;">
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="custom_admin_footer_text"><?php _e('Footer Text', 'quick-custom-admin'); ?></label>
                    </th>
                    <td>
                        <textarea id="custom_admin_footer_text" name="quick_custom_admin_options[custom_admin_footer_text]" rows="3" class="large-text"><?php echo wp_kses_post(isset($options['custom_admin_footer_text']) ? $options['custom_admin_footer_text'] : ''); ?></textarea>
                        <p class="description"><?php _e('Customize the footer text in the admin area. HTML is allowed.', 'quick-custom-admin'); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="hide_wp_version"><?php _e('Hide WordPress Version', 'quick-custom-admin'); ?></label>
                    </th>
                    <td>
                        <label class="quick-custom-admin-toggle">
                            <input type="checkbox" id="hide_wp_version" name="quick_custom_admin_options[hide_wp_version]" value="1" <?php checked(isset($options['hide_wp_version']) ? $options['hide_wp_version'] : false); ?> class="quick-custom-admin-toggle-section" data-target="#custom-version-options">
                            <span class="quick-custom-admin-toggle-slider"></span>
                        </label>
                        <p class="description"><?php _e('Hide the WordPress version information in the admin footer.', 'quick-custom-admin'); ?></p>
                    </td>
                </tr>
            </table>
            
            <div id="custom-version-options">
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="custom_version_text"><?php _e('Custom Version Text', 'quick-custom-admin'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="custom_version_text" name="quick_custom_admin_options[custom_version_text]" value="<?php echo esc_attr(isset($options['custom_version_text']) ? $options['custom_version_text'] : ''); ?>" class="regular-text">
                            <p class="description"><?php _e('Replace the WordPress version text with custom text. Leave empty to hide completely.', 'quick-custom-admin'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <?php submit_button(); ?>
    </form>
</div>
