<?php
/**
 * Provide a admin area view for the plugin's dashboard settings
 *
 * @link       https://plugins.quickpr.co/
 * @since      1.0.0
 *
 * @package    Quick_Custom_Admin
 * @subpackage Quick_Custom_Admin/admin/partials
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Get plugin options
$options = get_option('quick_custom_admin_options', array());

// Default dashboard widgets
$default_widgets = array(
    'dashboard_activity' => __('Activity', 'quick-custom-admin'),
    'dashboard_right_now' => __('At a Glance', 'quick-custom-admin'),
    'dashboard_quick_press' => __('Quick Draft', 'quick-custom-admin'),
    'dashboard_primary' => __('WordPress Events and News', 'quick-custom-admin'),
    'dashboard_site_health' => __('Site Health Status', 'quick-custom-admin'),
    'dashboard_at_a_glance' => __('At a Glance', 'quick-custom-admin'),
);

// Get custom dashboard widgets
$custom_widgets = isset($options['custom_dashboard_widgets']) ? $options['custom_dashboard_widgets'] : array();
?>

<div class="wrap quick-custom-admin-wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <h2 class="nav-tab-wrapper quick-custom-admin-tabs">
        <a href="#default-widgets" class="nav-tab nav-tab-active"><?php _e('Default Widgets', 'quick-custom-admin'); ?></a>
        <a href="#custom-widgets" class="nav-tab"><?php _e('Custom Widgets', 'quick-custom-admin'); ?></a>
    </h2>
    
    <form method="post" action="options.php">
        <?php settings_fields('quick_custom_admin_options'); ?>
        
        <!-- Default Widgets Tab -->
        <div id="default-widgets" class="quick-custom-admin-tab-content">
            <p><?php _e('Select which default WordPress dashboard widgets to remove:', 'quick-custom-admin'); ?></p>
            
            <table class="form-table">
                <?php foreach ($default_widgets as $widget_id => $widget_name) : ?>
                <tr>
                    <th scope="row">
                        <label for="remove_<?php echo esc_attr($widget_id); ?>"><?php echo esc_html($widget_name); ?></label>
                    </th>
                    <td>
                        <label class="quick-custom-admin-toggle">
                            <input type="checkbox" id="remove_<?php echo esc_attr($widget_id); ?>" name="quick_custom_admin_options[remove_dashboard_widgets][<?php echo esc_attr($widget_id); ?>]" value="1" <?php checked(isset($options['remove_dashboard_widgets'][$widget_id]) ? $options['remove_dashboard_widgets'][$widget_id] : false); ?>>
                            <span class="quick-custom-admin-toggle-slider"></span>
                        </label>
                        <p class="description"><?php printf(__('Remove the %s widget from the dashboard.', 'quick-custom-admin'), $widget_name); ?></p>
                    </td>
                </tr>
                <?php endforeach; ?>
            </table>
        </div>
        
        <!-- Custom Widgets Tab -->
        <div id="custom-widgets" class="quick-custom-admin-tab-content" style="display: none;">
            <p><?php _e('Create custom dashboard widgets to provide useful information to your clients:', 'quick-custom-admin'); ?></p>
            
            <div class="quick-custom-admin-sortable" id="custom-widgets-container">
                <?php if (!empty($custom_widgets)) : ?>
                    <?php foreach ($custom_widgets as $widget_id => $widget) : ?>
                        <div class="quick-custom-admin-sortable-item" data-id="<?php echo esc_attr($widget_id); ?>">
                            <h4><?php echo esc_html($widget['title']); ?></h4>
                            <div class="quick-custom-admin-sortable-item-actions">
                                <span class="quick-custom-admin-sortable-item-toggle dashicons dashicons-arrow-down-alt2"></span>
                                <a href="#" class="quick-custom-admin-sortable-item-delete"><?php _e('Delete', 'quick-custom-admin'); ?></a>
                            </div>
                            <div class="quick-custom-admin-sortable-item-content">
                                <table class="form-table">
                                    <tr>
                                        <th scope="row">
                                            <label for="widget_title_<?php echo esc_attr($widget_id); ?>"><?php _e('Widget Title', 'quick-custom-admin'); ?></label>
                                        </th>
                                        <td>
                                            <input type="text" id="widget_title_<?php echo esc_attr($widget_id); ?>" name="quick_custom_admin_options[custom_dashboard_widgets][<?php echo esc_attr($widget_id); ?>][title]" value="<?php echo esc_attr($widget['title']); ?>" class="regular-text quick-custom-admin-widget-title">
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row">
                                            <label for="widget_content_<?php echo esc_attr($widget_id); ?>"><?php _e('Widget Content', 'quick-custom-admin'); ?></label>
                                        </th>
                                        <td>
                                            <textarea id="widget_content_<?php echo esc_attr($widget_id); ?>" name="quick_custom_admin_options[custom_dashboard_widgets][<?php echo esc_attr($widget_id); ?>][content]" rows="5" class="large-text quick-custom-admin-widget-content"><?php echo esc_textarea($widget['content']); ?></textarea>
                                            <p class="description"><?php _e('HTML is allowed. You can use this to add links, images, or formatted text.', 'quick-custom-admin'); ?></p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row">
                                            <label for="widget_position_<?php echo esc_attr($widget_id); ?>"><?php _e('Widget Position', 'quick-custom-admin'); ?></label>
                                        </th>
                                        <td>
                                            <select id="widget_position_<?php echo esc_attr($widget_id); ?>" name="quick_custom_admin_options[custom_dashboard_widgets][<?php echo esc_attr($widget_id); ?>][position]">
                                                <option value="normal" <?php selected(isset($widget['position']) ? $widget['position'] : 'normal', 'normal'); ?>><?php _e('Left Column', 'quick-custom-admin'); ?></option>
                                                <option value="side" <?php selected(isset($widget['position']) ? $widget['position'] : 'normal', 'side'); ?>><?php _e('Right Column', 'quick-custom-admin'); ?></option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row">
                                            <label for="widget_priority_<?php echo esc_attr($widget_id); ?>"><?php _e('Widget Priority', 'quick-custom-admin'); ?></label>
                                        </th>
                                        <td>
                                            <select id="widget_priority_<?php echo esc_attr($widget_id); ?>" name="quick_custom_admin_options[custom_dashboard_widgets][<?php echo esc_attr($widget_id); ?>][priority]">
                                                <option value="high" <?php selected(isset($widget['priority']) ? $widget['priority'] : 'high', 'high'); ?>><?php _e('High', 'quick-custom-admin'); ?></option>
                                                <option value="core" <?php selected(isset($widget['priority']) ? $widget['priority'] : 'high', 'core'); ?>><?php _e('Core', 'quick-custom-admin'); ?></option>
                                                <option value="default" <?php selected(isset($widget['priority']) ? $widget['priority'] : 'high', 'default'); ?>><?php _e('Default', 'quick-custom-admin'); ?></option>
                                                <option value="low" <?php selected(isset($widget['priority']) ? $widget['priority'] : 'high', 'low'); ?>><?php _e('Low', 'quick-custom-admin'); ?></option>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row">
                                            <label for="widget_roles_<?php echo esc_attr($widget_id); ?>"><?php _e('Visible to Roles', 'quick-custom-admin'); ?></label>
                                        </th>
                                        <td>
                                            <?php
                                            $roles = get_editable_roles();
                                            $widget_roles = isset($widget['roles']) ? $widget['roles'] : array();
                                            foreach ($roles as $role_id => $role) :
                                            ?>
                                            <label>
                                                <input type="checkbox" name="quick_custom_admin_options[custom_dashboard_widgets][<?php echo esc_attr($widget_id); ?>][roles][]" value="<?php echo esc_attr($role_id); ?>" <?php checked(in_array($role_id, $widget_roles) || empty($widget_roles)); ?>>
                                                <?php echo esc_html($role['name']); ?>
                                            </label><br>
                                            <?php endforeach; ?>
                                            <p class="description"><?php _e('Select which user roles can see this widget. If none selected, all roles will see it.', 'quick-custom-admin'); ?></p>
                                        </td>
                                    </tr>
                                </table>
                                
                                <h4><?php _e('Widget Preview', 'quick-custom-admin'); ?></h4>
                                <div class="quick-custom-admin-widget-preview">
                                    <div class="quick-custom-admin-widget-preview-title"><?php echo esc_html($widget['title']); ?></div>
                                    <div class="quick-custom-admin-widget-preview-content"><?php echo wp_kses_post($widget['content']); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
            
            <input type="hidden" id="custom-widgets-order" name="quick_custom_admin_options[custom_widgets_order]" value="<?php echo esc_attr(isset($options['custom_widgets_order']) ? $options['custom_widgets_order'] : ''); ?>" class="quick-custom-admin-sortable-order">
            
            <script type="text/html" id="custom-widget-template" style="display: none;">
                <div class="quick-custom-admin-sortable-item" data-id="{id}">
                    <h4><?php _e('New Widget', 'quick-custom-admin'); ?></h4>
                    <div class="quick-custom-admin-sortable-item-actions">
                        <span class="quick-custom-admin-sortable-item-toggle dashicons dashicons-arrow-down-alt2"></span>
                        <a href="#" class="quick-custom-admin-sortable-item-delete"><?php _e('Delete', 'quick-custom-admin'); ?></a>
                    </div>
                    <div class="quick-custom-admin-sortable-item-content">
                        <table class="form-table">
                            <tr>
                                <th scope="row">
                                    <label for="widget_title_{id}"><?php _e('Widget Title', 'quick-custom-admin'); ?></label>
                                </th>
                                <td>
                                    <input type="text" id="widget_title_{id}" name="quick_custom_admin_options[custom_dashboard_widgets][{id}][title]" value="<?php _e('New Widget', 'quick-custom-admin'); ?>" class="regular-text quick-custom-admin-widget-title">
                                </td>
                            </tr>
                            <tr>
                                <th scope="row">
                                    <label for="widget_content_{id}"><?php _e('Widget Content', 'quick-custom-admin'); ?></label>
                                </th>
                                <td>
                                    <textarea id="widget_content_{id}" name="quick_custom_admin_options[custom_dashboard_widgets][{id}][content]" rows="5" class="large-text quick-custom-admin-widget-content"><?php _e('Enter your widget content here...', 'quick-custom-admin'); ?></textarea>
                                    <p class="description"><?php _e('HTML is allowed. You can use this to add links, images, or formatted text.', 'quick-custom-admin'); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row">
                                    <label for="widget_position_{id}"><?php _e('Widget Position', 'quick-custom-admin'); ?></label>
                                </th>
                                <td>
                                    <select id="widget_position_{id}" name="quick_custom_admin_options[custom_dashboard_widgets][{id}][position]">
                                        <option value="normal"><?php _e('Left Column', 'quick-custom-admin'); ?></option>
                                        <option value="side"><?php _e('Right Column', 'quick-custom-admin'); ?></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row">
                                    <label for="widget_priority_{id}"><?php _e('Widget Priority', 'quick-custom-admin'); ?></label>
                                </th>
                                <td>
                                    <select id="widget_priority_{id}" name="quick_custom_admin_options[custom_dashboard_widgets][{id}][priority]">
                                        <option value="high"><?php _e('High', 'quick-custom-admin'); ?></option>
                                        <option value="core"><?php _e('Core', 'quick-custom-admin'); ?></option>
                                        <option value="default"><?php _e('Default', 'quick-custom-admin'); ?></option>
                                        <option value="low"><?php _e('Low', 'quick-custom-admin'); ?></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row">
                                    <label for="widget_roles_{id}"><?php _e('Visible to Roles', 'quick-custom-admin'); ?></label>
                                </th>
                                <td>
                                    <?php
                                    $roles = get_editable_roles();
                                    foreach ($roles as $role_id => $role) :
                                    ?>
                                    <label>
                                        <input type="checkbox" name="quick_custom_admin_options[custom_dashboard_widgets][{id}][roles][]" value="<?php echo esc_attr($role_id); ?>" checked>
                                        <?php echo esc_html($role['name']); ?>
                                    </label><br>
                                    <?php endforeach; ?>
                                    <p class="description"><?php _e('Select which user roles can see this widget. If none selected, all roles will see it.', 'quick-custom-admin'); ?></p>
                                </td>
                            </tr>
                        </table>
                        
                        <h4><?php _e('Widget Preview', 'quick-custom-admin'); ?></h4>
                        <div class="quick-custom-admin-widget-preview">
                            <div class="quick-custom-admin-widget-preview-title"><?php _e('New Widget', 'quick-custom-admin'); ?></div>
                            <div class="quick-custom-admin-widget-preview-content"><?php _e('Enter your widget content here...', 'quick-custom-admin'); ?></div>
                        </div>
                    </div>
                </div>
            </script>
            
            <p>
                <button type="button" class="button quick-custom-admin-add-new" data-template="#custom-widget-template" data-container="#custom-widgets-container"><?php _e('Add New Widget', 'quick-custom-admin'); ?></button>
            </p>
        </div>
        
        <?php submit_button(); ?>
    </form>
</div>
