/**
 * All of the JavaScript for your admin-specific functionality should be
 * included in this file.
 *
 * @link       https://plugins.quickpr.co/
 * @since      1.0.0
 *
 * @package    Quick_Custom_Admin
 * @subpackage Quick_Custom_Admin/admin/js
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Initialize color pickers
        $('.quick-custom-admin-color-picker').wpColorPicker();

        // Initialize sortable elements
        $('.quick-custom-admin-sortable').sortable({
            handle: 'h4',
            update: function(event, ui) {
                // Update order in hidden field
                updateSortableOrder($(this));
            }
        });

        // Toggle sortable item content
        $(document).on('click', '.quick-custom-admin-sortable-item-toggle', function(e) {
            e.preventDefault();
            $(this).closest('.quick-custom-admin-sortable-item').find('.quick-custom-admin-sortable-item-content').slideToggle();
        });

        // Delete sortable item
        $(document).on('click', '.quick-custom-admin-sortable-item-delete', function(e) {
            e.preventDefault();
            if (confirm(quick_custom_admin_params.i18n.confirm_delete)) {
                $(this).closest('.quick-custom-admin-sortable-item').remove();
                // Update order in hidden field
                updateSortableOrder($(this).closest('.quick-custom-admin-sortable'));
            }
        });

        // Add new sortable item
        $('.quick-custom-admin-add-new').on('click', function(e) {
            e.preventDefault();
            var template = $(this).data('template');
            var container = $(this).data('container');
            var itemId = 'item-' + Date.now();
            
            // Clone template and replace placeholder ID
            var newItem = $(template).html().replace(/\{id\}/g, itemId);
            $(container).append(newItem);
            
            // Initialize color pickers in the new item
            $(container).find('.quick-custom-admin-color-picker').wpColorPicker();
            
            // Update order in hidden field
            updateSortableOrder($(container));
        });

        // Media uploader for image fields
        $(document).on('click', '.quick-custom-admin-upload-button', function(e) {
            e.preventDefault();
            
            var button = $(this);
            var imageField = button.prev('.quick-custom-admin-image-field');
            var previewContainer = button.next('.quick-custom-admin-image-preview');
            
            // Create the media frame
            var frame = wp.media({
                title: quick_custom_admin_params.i18n.select_image,
                multiple: false,
                library: {
                    type: 'image'
                },
                button: {
                    text: quick_custom_admin_params.i18n.use_image
                }
            });
            
            // When an image is selected, run a callback
            frame.on('select', function() {
                var attachment = frame.state().get('selection').first().toJSON();
                imageField.val(attachment.url);
                
                // Update preview
                if (previewContainer.length) {
                    if (previewContainer.find('img').length) {
                        previewContainer.find('img').attr('src', attachment.url);
                    } else {
                        previewContainer.html('<img src="' + attachment.url + '" alt="" />');
                    }
                    previewContainer.show();
                }
                
                // Show remove button
                button.next('.quick-custom-admin-remove-image').show();
            });
            
            // Open the modal
            frame.open();
        });
        
        // Remove image
        $(document).on('click', '.quick-custom-admin-remove-image', function(e) {
            e.preventDefault();
            
            var button = $(this);
            var imageField = button.prevAll('.quick-custom-admin-image-field');
            var previewContainer = button.next('.quick-custom-admin-image-preview');
            
            // Clear the field
            imageField.val('');
            
            // Hide preview
            previewContainer.hide().html('');
            
            // Hide remove button
            button.hide();
        });
        
        // Toggle sections based on checkbox state
        $('.quick-custom-admin-toggle-section').on('change', function() {
            var targetSection = $(this).data('target');
            if ($(this).is(':checked')) {
                $(targetSection).slideDown();
            } else {
                $(targetSection).slideUp();
            }
        }).trigger('change');
        
        // Initialize tabs
        if ($('.quick-custom-admin-tabs').length) {
            $('.quick-custom-admin-tab-content').hide();
            $('.quick-custom-admin-tab-content:first').show();
            $('.quick-custom-admin-tabs a:first').addClass('nav-tab-active');
            
            $('.quick-custom-admin-tabs a').on('click', function(e) {
                e.preventDefault();
                $('.quick-custom-admin-tabs a').removeClass('nav-tab-active');
                $(this).addClass('nav-tab-active');
                $('.quick-custom-admin-tab-content').hide();
                $($(this).attr('href')).show();
            });
        }
        
        // Update notice preview
        $('.quick-custom-admin-notice-type, .quick-custom-admin-notice-message').on('change keyup', function() {
            updateNoticePreview($(this).closest('form'));
        });
        
        // Update dashboard widget preview
        $('.quick-custom-admin-widget-title, .quick-custom-admin-widget-content').on('change keyup', function() {
            updateWidgetPreview($(this).closest('.quick-custom-admin-sortable-item'));
        });
        
        // Update help tab preview
        $('.quick-custom-admin-help-title, .quick-custom-admin-help-content').on('change keyup', function() {
            updateHelpPreview($(this).closest('.quick-custom-admin-sortable-item'));
        });
        
        // Update color scheme preview
        $('.quick-custom-admin-color-scheme-color').on('change', function() {
            updateColorSchemePreview($(this).closest('.quick-custom-admin-sortable-item'));
        });
        
        // Initialize all previews
        $('.quick-custom-admin-sortable-item').each(function() {
            if ($(this).find('.quick-custom-admin-notice-type').length) {
                updateNoticePreview($(this));
            }
            if ($(this).find('.quick-custom-admin-widget-title').length) {
                updateWidgetPreview($(this));
            }
            if ($(this).find('.quick-custom-admin-help-title').length) {
                updateHelpPreview($(this));
            }
            if ($(this).find('.quick-custom-admin-color-scheme-color').length) {
                updateColorSchemePreview($(this));
            }
        });
    });
    
    // Helper function to update sortable order in hidden field
    function updateSortableOrder(container) {
        var items = [];
        container.find('.quick-custom-admin-sortable-item').each(function() {
            items.push($(this).data('id'));
        });
        container.next('.quick-custom-admin-sortable-order').val(JSON.stringify(items));
    }
    
    // Helper function to update notice preview
    function updateNoticePreview(container) {
        var type = container.find('.quick-custom-admin-notice-type').val();
        var message = container.find('.quick-custom-admin-notice-message').val();
        var preview = container.find('.quick-custom-admin-notice-preview');
        
        preview.removeClass('notice-info notice-success notice-warning notice-error').addClass('notice-' + type);
        preview.html('<p>' + message + '</p>');
    }
    
    // Helper function to update widget preview
    function updateWidgetPreview(container) {
        var title = container.find('.quick-custom-admin-widget-title').val();
        var content = container.find('.quick-custom-admin-widget-content').val();
        var preview = container.find('.quick-custom-admin-widget-preview');
        
        preview.find('.quick-custom-admin-widget-preview-title').text(title);
        preview.find('.quick-custom-admin-widget-preview-content').html(content);
    }
    
    // Helper function to update help preview
    function updateHelpPreview(container) {
        var title = container.find('.quick-custom-admin-help-title').val();
        var content = container.find('.quick-custom-admin-help-content').val();
        var preview = container.find('.quick-custom-admin-help-preview');
        
        preview.find('.quick-custom-admin-help-preview-title').text(title);
        preview.find('.quick-custom-admin-help-preview-content').html(content);
    }
    
    // Helper function to update color scheme preview
    function updateColorSchemePreview(container) {
        container.find('.quick-custom-admin-color-scheme-color').each(function() {
            var color = $(this).val();
            var swatch = container.find('.quick-custom-admin-color-swatch[data-color="' + $(this).data('color') + '"]');
            swatch.css('background-color', color);
        });
    }

})(jQuery);
