# Quick Custom Admin

A powerful WordPress plugin that allows you to customize the WordPress admin area with white labeling, custom dashboard widgets, and role-based restrictions.

## Features

### White Labeling
- Replace WordPress branding with your own company branding
- Customize the admin title
- Replace the WordPress logo in the login screen
- Change the login logo URL and title
- Replace the WordPress logo in the admin bar
- Customize the admin footer text
- Hide or replace the WordPress version text

### Dashboard Customization
- Remove default WordPress dashboard widgets
- Create custom dashboard widgets with HTML content
- Control widget position and priority
- Restrict widgets to specific user roles

### Admin Menu Customization
- Hide menu items based on user roles
- Rename menu items
- Reorder menu items

### Role-Based Restrictions
- Restrict access to admin pages based on user roles
- Adjust user capabilities

### Admin Columns
- Customize post and page columns in admin lists
- Add custom columns with dynamic content

### Admin Notices
- Create custom admin notices
- Control notice type (info, success, warning, error)
- Schedule notices to appear on specific dates
- Restrict notices to specific user roles

## Installation

1. Upload the `quick-custom-admin` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Configure the plugin settings through the 'Custom Admin' menu in the WordPress admin

## Usage

### White Labeling

Navigate to Custom Admin > White Label to configure:
- Enable white labeling
- Set custom admin title
- Upload custom login logo
- Set logo URL and title
- Replace WordPress logo in admin bar
- Customize footer text
- Hide or replace WordPress version text

### Dashboard Customization

Navigate to Custom Admin > Dashboard to:
- Remove default WordPress dashboard widgets
- Create custom dashboard widgets
- Set widget content, position, and priority
- Control widget visibility by user role

### Admin Menu Customization

Navigate to Custom Admin > Admin Menu to:
- Hide specific menu items
- Rename menu items
- Reorder menu items
- Set menu visibility by user role

### Role-Based Restrictions

Navigate to Custom Admin > Role Restrictions to:
- Restrict access to admin pages
- Adjust user capabilities
- Create custom permission sets

### Admin Columns

Navigate to Custom Admin > Admin Columns to:
- Customize columns for posts, pages, and custom post types
- Add custom columns with dynamic content
- Remove default columns

### Admin Notices

Navigate to Custom Admin > Admin Notices to:
- Create custom admin notices
- Set notice type (info, success, warning, error)
- Schedule notices to appear on specific dates
- Restrict notices to specific user roles

## Support

For support, please contact [info@quickpr.co](mailto:info@quickpr.co) or visit [https://plugins.quickpr.co/](https://plugins.quickpr.co/)

## License

This plugin is licensed under the GPL v2 or later.

```
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
```
